<?php
$block_id = $block_id_prefix.'cat';
$block_label = __( 'Category: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type' => 'text',
		'css_class' => 'biz',
	)) 
);

$block_id = $block_id_prefix.'tag';
$block_label = __( 'Tag: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type' => 'text',
		'css_class' => 'biz',
	)) 
);

$block_id = $block_id_prefix.'limit';
$block_label = __( 'Post Limit: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type' => 'text',
		'css_class' => 'biz',
	)) 
);

$block_id = $block_id_prefix.'column';
$block_label = __( 'Column: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'select',
		'css_class' => 'biz',
		'choices'    => array(
			'3'     => __('3 Column', 'tally_textdomain'),
			'4'     => __('4 Column', 'tally_textdomain'),
			'1'     => __('1 Column', 'tally_textdomain'),
			'2'     => __('2 Column', 'tally_textdomain'),
			'5'     => __('5 Column', 'tally_textdomain'),
		), 
	)) 
);

$block_id = $block_id_prefix.'link';
$block_label = __( 'Link: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'text',
	)) 
);
$block_id = $block_id_prefix.'more';
$block_label = __( 'View Blog Text: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'text',
	)) 
);

$block_id = $block_id_prefix.'heading_tag';
$block_label = __( 'Heading [Tag]: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => 'h4', 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'select',
		'choices'    => array(
			'h1'  => __('h1', 'tally_textdomain'),
			'h2'  => __('h2', 'tally_textdomain'),
			'h3'  => __('h3', 'tally_textdomain'),
			'h4'  => __('h4', 'tally_textdomain'),
			'h5'  => __('h5', 'tally_textdomain'),
			'h6'  => __('h6', 'tally_textdomain'),
			'p'  => __('p', 'tally_textdomain'),
			'strong'  => __('strong', 'tally_textdomain'),
		),
	)) 
);