<?php
$block_id = $block_id_prefix.'title';
$block_label = __( 'Title: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'text',
	)) 
);

$block_id = $block_id_prefix.'subtitle';
$block_label = __( 'Sub-Title: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'text',
	)) 
);

$block_id = $block_id_prefix.'des';
$block_label = __( 'Description: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'textarea',
	)) 
);

$block_id = $block_id_prefix.'link';
$block_label = __( 'Link: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'text',
	)) 
);

$block_id = $block_id_prefix.'more';
$block_label = __( 'ReadMore Text: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'text',
	)) 
);
$block_id = $block_id_prefix.'align';
$block_label = __( 'Text Align: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => tally_option_default($block_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'select',
		'css_class' => 'biz',
		'choices'    => array(
			'left'     => __('Left', 'tally_textdomain'),
			'right'     => __('Right', 'tally_textdomain'),
			'center'     => __('Center', 'tally_textdomain'),
			'none'     => __('None', 'tally_textdomain'),
		),
	)) 
);
$block_id = $block_id_prefix.'heading_tag';
$block_label = __( 'Heading [Tag]: ', 'tally_textdomain' );
$wp_customize->add_setting( $block_id, array('default' => 'h4', 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
	array(
		'label' => $block_label,
		'section' => $block_section,
		'settings' => $block_id,
		'priority' => 10,
		'type'       => 'select',
		'choices'    => array(
			'h1'  => __('h1', 'tally_textdomain'),
			'h2'  => __('h2', 'tally_textdomain'),
			'h3'  => __('h3', 'tally_textdomain'),
			'h4'  => __('h4', 'tally_textdomain'),
			'h5'  => __('h5', 'tally_textdomain'),
			'h6'  => __('h6', 'tally_textdomain'),
			'p'  => __('p', 'tally_textdomain'),
			'strong'  => __('strong', 'tally_textdomain'),
		),
	)) 
);