<?php
function tally_customizer_color_register($wp_customize){
	$wp_customize->add_panel( 'tally_color', array(
		'title' => 'Color & Background',
		'description' => 'Manage color and background of the theme.',
	));
	
	$wp_customize->add_section( 'tally_accent_color', 
		array(
			'title' => __( 'Accent Color', 'tally_textdomain' ),
            'description' => __('Customize the Accent color of the theme.', 'tally_textdomain'),
			'panel' => 'tally_color',
		) 
	);
	
	$wp_customize->add_section( 'tally_menu_color', 
		array(
			'title' => __( 'Menu Color', 'tally_textdomain' ),
            'description' => __('Customize the Menu color of the theme.', 'tally_textdomain'),
			'panel' => 'tally_color',
		) 
	);
	$wp_customize->add_section( 'tally_subheader_color', 
		array(
			'title' => __( 'Sub-Header Color', 'tally_textdomain' ),
            'description' => __('Customize the sub-header color of the theme.', 'tally_textdomain'),
			'panel' => 'tally_color',
		) 
	);
	$wp_customize->add_section( 'tally_main_color', 
		array(
			'title' => __( 'Main Color', 'tally_textdomain' ),
            'description' => __('Customize the Main color of the theme.', 'tally_textdomain'),
			'panel' => 'tally_color',
		) 
	);
	$wp_customize->add_section( 'tally_fwidget_color', 
		array(
			'title' => __( 'Footer Widget area Color', 'tally_textdomain' ),
            'description' => __('Customize the Footer Widget area color of the theme.', 'tally_textdomain'),
			'panel' => 'tally_color',
		) 
	);
	$wp_customize->add_section( 'tally_footer_color', 
		array(
			'title' => __( 'Footer Color', 'tally_textdomain' ),
            'description' => __('Customize the Footer color of the theme.', 'tally_textdomain'),
			'panel' => 'tally_color',
		) 
	);
	
	
	/*	Accent Color
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	$prefix = 'tally_color_accent_';
	$section = 'tally_accent_color';
	
	/*-~- Info -~-*/
	if(tally_config('type') == 'none'){ 
		$uid = $prefix.'info1';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $uid, 
			array(
				'label' => '',
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over Accent Color',
			)) 
		);
	}
		
		/*-~- Primary Color -~-*/
		$uid = $prefix.'primary';
		$wp_customize->add_setting( $prefix.'primary', array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Primary Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Success Color -~-*/
		$uid = $prefix.'success';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Success Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Info Color -~-*/
		$uid = $prefix.'info';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Info Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Warning Color -~-*/
		$uid = $prefix.'warning';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Warning Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Danger Color -~-*/
		$uid = $prefix.'danger';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Danger Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);

	
	/*	Menu Color
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	$prefix = 'tally_color_menu_';
	$section = 'tally_menu_color';
	
	/*-~- Info -~-*/
	if(tally_config('type') == 'none'){ 
		$uid = $prefix.'info1';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $uid, 
			array(
				'label' => '',
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over Menu Color',
			)) 
		);
	}
	

		/*-~- Text Color -~-*/
		$uid = $prefix.'text';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Text Hover Color -~-*/
		$uid = $prefix.'textHover';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Color -~-*/
		$uid = $prefix.'border';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Hover Color -~-*/
		$uid = $prefix.'borderHover';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Color -~-*/
		$uid = $prefix.'bg';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Hover Color -~-*/
		$uid = $prefix.'bgHover';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- SubNav Text Color -~-*/
		$uid = $prefix.'textSub';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'SubNav Text Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- SubNav Text Hover Color -~-*/
		$uid = $prefix.'textHoverSub';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'SubNav Text Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- SubNav Border Color -~-*/
		$uid = $prefix.'borderSub';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'SubNav Border Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- SubNav Border Hover Color -~-*/
		$uid = $prefix.'borderHoverSub';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'SubNav Border Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- SubNav Background Color -~-*/
		$uid = $prefix.'bgSub';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'SubNav Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- SubNav Background Hover Color -~-*/
		$uid = $prefix.'bgHoverSub';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'SubNav Background Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		
		/*-~- Nav Area Background Color -~-*/
		$uid = $prefix.'navBG';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Nav Area Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);

	
	
	
	
	
	
	/*	Sub-Header Color
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	$prefix = 'tally_color_subheader_';
	$section = 'tally_subheader_color';
	
	/*-~- Info -~-*/
	if(tally_config('type') == 'none'){ 
		$uid = $prefix.'info1';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $uid, 
			array(
				'label' => '',
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over SubHeader Color',
			)) 
		);
	}
	

		/*-~- Heading Color -~-*/
		$uid = $prefix.'heading';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Heading Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Sub-Heading Color -~-*/
		$uid = $prefix.'subheading';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Sub-Heading Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Text Color -~-*/
		$uid = $prefix.'text';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Color -~-*/
		$uid = $prefix.'bg';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Image -~-*/
		$uid = $prefix.'bgImage';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
			)) 
		);
		
		/*-~- Background Image Repeat -~-*/
		$uid = $prefix.'bgImage_repeat';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Repeat', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'no-repeat'  => __('No Repeat', 'tally_textdomain'),
					'repeat'     => __('Tile', 'tally_textdomain'),
					'repeat-x'   => __('Tile Horizontally', 'tally_textdomain'),
					'repeat-y'   => __('Tile Vertically', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Position -~-*/
		$uid = $prefix.'bgImage_position';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Position', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'top left'  => __('Top Left', 'tally_textdomain'),
					'top right'     => __('Top Right', 'tally_textdomain'),
					'top center'   => __('Top Center', 'tally_textdomain'),
					'center center'   => __('Center Center', 'tally_textdomain'),
					'bottom left'  => __('Top Left', 'tally_textdomain'),
					'bottom right'     => __('Top Right', 'tally_textdomain'),
					'bottom center'   => __('Top Center', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Attachment -~-*/
		$uid = $prefix.'bgImage_attachment';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Attachment', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'scroll'     => __('Scroll', 'tally_textdomain'),
					'fixed'      => __('Fixed', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Size -~-*/
		$uid = $prefix.'bgImage_size';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Size', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'text',
				'css_class' => 'biz',
			)) 
		);

	
	
	
	
	
	/*	Main Color
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	$prefix = 'tally_color_main_';
	$section = 'tally_main_color';
	
	/*-~- Info -~-*/
	if(tally_config('type') == 'none'){ 
		$uid = $prefix.'info1';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $uid, 
			array(
				'label' => '',
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over Main Content Color',
			)) 
		);
	}
	
	
		/*-~- Heading Color -~-*/
		$uid = $prefix.'heading';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Heading Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Heading Alt Color -~-*/
		$uid = $prefix.'headingAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Heading Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Text Color -~-*/
		$uid = $prefix.'text';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Text Meta Color -~-*/
		$uid = $prefix.'textMeta';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Meta Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Text Alt Color -~-*/
		$uid = $prefix.'textAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Color -~-*/
		$uid = $prefix.'border';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Alt Color -~-*/
		$uid = $prefix.'borderAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Color -~-*/
		$uid = $prefix.'bg';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Alt Color -~-*/
		$uid = $prefix.'bgAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Image -~-*/
		$uid = $prefix.'bgImage';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
			)) 
		);
		
		/*-~- Background Image Repeat -~-*/
		$uid = $prefix.'bgImage_repeat';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Repeat', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type' => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'no-repeat'  => __('No Repeat', 'tally_textdomain'),
					'repeat'     => __('Tile', 'tally_textdomain'),
					'repeat-x'   => __('Tile Horizontally', 'tally_textdomain'),
					'repeat-y'   => __('Tile Vertically', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Position -~-*/
		$uid = $prefix.'bgImage_position';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Position', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type' => 'select',
				'css_class' => 'biz',
				'choices' => array(
					'top left'  => __('Top Left', 'tally_textdomain'),
					'top right'     => __('Top Right', 'tally_textdomain'),
					'top center'   => __('Top Center', 'tally_textdomain'),
					'center center'   => __('Center Center', 'tally_textdomain'),
					'bottom left'  => __('Top Left', 'tally_textdomain'),
					'bottom right'     => __('Top Right', 'tally_textdomain'),
					'bottom center'   => __('Top Center', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Attachment -~-*/
		$uid = $prefix.'bgImage_attachment';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Attachment', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type' => 'select',
				'css_class' => 'biz',
				'choices' => array(
					'scroll' => __('Scroll', 'tally_textdomain'),
					'fixed' => __('Fixed', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Size -~-*/
		$uid = $prefix.'bgImage_size';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Size', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type' => 'text',
				'css_class' => 'biz',
				
			)) 
		);

	
	
	
	
	
	/*	Footer Widgets Color
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	$prefix = 'tally_color_fwidget_';
	$section = 'tally_fwidget_color';
	
	/*-~- Info -~-*/
	if(tally_config('type') == 'none'){ 
		$uid = $prefix.'info1';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $uid, 
			array(
				'label' => '',
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over Footer Widget Area Color',
			)) 
		);
	}
	
	
		/*-~- Heading Color -~-*/
		$uid = $prefix.'heading';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Heading Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);	
		
		/*-~- Text Color -~-*/
		$uid = $prefix.'text';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Text Meta Color -~-*/
		$uid = $prefix.'textMeta';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Meta Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		
		/*-~- Border Color -~-*/
		$uid = $prefix.'border';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Alt Color -~-*/
		$uid = $prefix.'borderAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Color -~-*/
		$uid = $prefix.'bg';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Alt Color -~-*/
		$uid = $prefix.'bgAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Link Color -~-*/
		$uid = $prefix.'link';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Link Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Link Hover Color -~-*/
		$uid = $prefix.'linkHover';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Link Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Image -~-*/
		$uid = $prefix.'bgImage';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Image Repeat -~-*/
		$uid = $prefix.'bgImage_repeat';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Repeat', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'no-repeat'  => __('No Repeat', 'tally_textdomain'),
					'repeat'     => __('Tile', 'tally_textdomain'),
					'repeat-x'   => __('Tile Horizontally', 'tally_textdomain'),
					'repeat-y'   => __('Tile Vertically', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Position -~-*/
		$uid = $prefix.'bgImage_position';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Position', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'top left'  => __('Top Left', 'tally_textdomain'),
					'top right'     => __('Top Right', 'tally_textdomain'),
					'top center'   => __('Top Center', 'tally_textdomain'),
					'center center'   => __('Center Center', 'tally_textdomain'),
					'bottom left'  => __('Top Left', 'tally_textdomain'),
					'bottom right'     => __('Top Right', 'tally_textdomain'),
					'bottom center'   => __('Top Center', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Attachment -~-*/
		$uid = $prefix.'bgImage_attachment';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Attachment', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'scroll'     => __('Scroll', 'tally_textdomain'),
					'fixed'      => __('Fixed', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Size -~-*/
		$uid = $prefix.'bgImage_size';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Size', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'text',
				'css_class' => 'biz',
			)) 
		);
	
	
	
	/*	Footer Color
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	$prefix = 'tally_color_footer_';
	$section = 'tally_footer_color';
	
	/*-~- Info -~-*/
	if(tally_config('type') == 'none'){ 
		$uid = $prefix.'info1';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $uid, 
			array(
				'label' => '',
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over Footer area Color',
			)) 
		);
	}
	
	
		/*-~- Text Color -~-*/
		$uid = $prefix.'text';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Text Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Color -~-*/
		$uid = $prefix.'border';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Border Alt Color -~-*/
		$uid = $prefix.'borderAlt';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Border Alt Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Color -~-*/
		$uid = $prefix.'bg';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Background Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Link Color -~-*/
		$uid = $prefix.'link';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Link Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Link Hover Color -~-*/
		$uid = $prefix.'linkHover';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $uid, 
			array(
				'label' => __( 'Link Hover Color', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'css_class' => 'biz',
			)) 
		);
		
		/*-~- Background Image -~-*/
		$uid = $prefix.'bgImage';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
			)) 
		);
		
		/*-~- Background Image Repeat -~-*/
		$uid = $prefix.'bgImage_repeat';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Repeat', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'no-repeat'  => __('No Repeat', 'tally_textdomain'),
					'repeat'     => __('Tile', 'tally_textdomain'),
					'repeat-x'   => __('Tile Horizontally', 'tally_textdomain'),
					'repeat-y'   => __('Tile Vertically', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Position -~-*/
		$uid = $prefix.'bgImage_position';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Position', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'top left'  => __('Top Left', 'tally_textdomain'),
					'top right'     => __('Top Right', 'tally_textdomain'),
					'top center'   => __('Top Center', 'tally_textdomain'),
					'center center'   => __('Center Center', 'tally_textdomain'),
					'bottom left'  => __('Top Left', 'tally_textdomain'),
					'bottom right'     => __('Top Right', 'tally_textdomain'),
					'bottom center'   => __('Top Center', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Attachment -~-*/
		$uid = $prefix.'bgImage_attachment';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Attachment', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type'       => 'select',
				'css_class' => 'biz',
				'choices'    => array(
					'scroll'     => __('Scroll', 'tally_textdomain'),
					'fixed'      => __('Fixed', 'tally_textdomain'),
				),
			)) 
		);
		
		/*-~- Background Image Size -~-*/
		$uid = $prefix.'bgImage_size';
		$wp_customize->add_setting( $uid, array('default' => tally_option_default($uid), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $uid, 
			array(
				'label' => __( 'Background Image Size', 'tally_textdomain' ),
				'section' => $section,
				'settings' => $uid,
				'priority' => 10,
				'type' => 'text',
				'css_class' => 'biz',
			)) 
		);
	
}
add_action( 'customize_register' , 'tally_customizer_color_register' );