<?php
function tally_home_customiser_builder($wp_customize){
	
	if(tally_file_directory('includes/trunk/'. tally_config('slug').'/'.tally_config('slug').'_home-data.php')){
		include(tally_file_directory('includes/trunk/'.tally_config('slug').'/'.tally_config('slug').'_home-data.php'));
	}else{
		include(tally_file_directory('home/home-data.php'));
	}
	
	foreach($tally_home_data as $tally_home){
		
		
		/*
			Building the panel
		--------------------------------------------------------------------------*/
		$wp_customize->add_panel( $tally_home['id'], array(
			'title' => $tally_home['label'],
		));
		
		
		/*
			Building  Enabel section
		--------------------------------------------------------------------------*/
		
		$s_section = $tally_home['id'].'_settings';
		$wp_customize->add_section( $s_section, 
			array(
				'title' => __( 'Settings', 'tally_textdomain' ),
				'panel' => $tally_home['id'],
				
			) 
		);
		$s_id = $s_section.'_enable';
		$s_label = __( 'Enabel This Home Page Section', 'tally_textdomain' );
		$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
		$wp_customize->add_control( new WP_Customize_Control($wp_customize, $s_id, 
			array(
				'label' => $s_label,
				'section' => $s_section,
				'settings' => $s_id,
				'priority' => 10,
				'type'       => 'checkbox',
			)) 
		);

		if($tally_home['background'] == true):
			$s_id = $s_section.'_bgImage';
			$s_label = __( 'Background Image', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
				)) 
			);
			
			/*-~- Info -~-*/
			if(tally_config('type') == 'none'){ 
				$s_id = $s_section.'_info1';
				$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
				$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $s_id, 
					array(
						'label' => '',
						'section' => $s_section,
						'settings' => $s_id,
						'priority' => 10,
						'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over the Background of this section.',
					)) 
				);
			}
			
			$s_id = $s_section.'_bgColor';
			$s_label = __( 'Background Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_bgAltColor';
			$s_label = __( 'Background Alt Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_bgRepeat';
			$s_label = __( 'Background Repeat', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'select',
					'css_class' => 'biz',
					'choices'    => array(
						'no-repeat'  => __('No Repeat', 'tally_textdomain'),
						'repeat'     => __('Tile', 'tally_textdomain'),
						'repeat-x'   => __('Tile Horizontally', 'tally_textdomain'),
						'repeat-y'   => __('Tile Vertically', 'tally_textdomain'),
					),
				)) 
			);
			$s_id = $s_section.'_bgPosition';
			$s_label = __( 'Background Position', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'select',
					'css_class' => 'biz',
					'choices'    => array(
						'top left'  => __('Top Left', 'tally_textdomain'),
						'top right'     => __('Top Right', 'tally_textdomain'),
						'top center'   => __('Top Center', 'tally_textdomain'),
						'center center'   => __('Center Center', 'tally_textdomain'),
						'bottom left'  => __('Top Left', 'tally_textdomain'),
						'bottom right'     => __('Top Right', 'tally_textdomain'),
						'bottom center'   => __('Top Center', 'tally_textdomain'),
					),
				)) 
			);
			$s_id = $s_section.'_bgAttachment';
			$s_label = __( 'Background Attachment', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'select',
					'css_class' => 'biz',
					'choices'    => array(
						'scroll'     => __('Scroll', 'tally_textdomain'),
						'fixed'      => __('Fixed', 'tally_textdomain'),
					),
				)) 
			);
			$s_id = $s_section.'_bgSize';
			$s_label = __( 'Background Size', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'text',
					'css_class' => 'biz',
				)) 
			);
		
		endif;
			
			
			
		if($tally_home['settings'] == true):
			/*-~- Info -~-*/
			if(tally_config('type') == 'none'){ 
				$s_id = $s_section.'_info2';
				$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
				$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $s_id, 
					array(
						'label' => '',
						'section' => $s_section,
						'settings' => $s_id,
						'priority' => 10,
						'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over the Stiings.',
					)) 
				);
			}
			$s_id = $s_section.'_contentWidth';
			$s_label = __( 'Content Width', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'text',
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_topPadding';
			$s_label = __( 'Top Padding', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_bottomPadding';
			$s_label = __( 'Bottom Padding', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_class';
			$s_label = __( 'Class', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_divID';
			$s_label = __( 'CSS ID', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
		endif;
		
		/*
			Building  heading section
		--------------------------------------------------------------------------*/
		if($tally_home['heading'] == true):
			$s_section = $tally_home['id'].'_heading';
			$wp_customize->add_section( $s_section, 
				array(
					'title' => __( 'Heading', 'tally_textdomain' ),
					'panel' => $tally_home['id'],
				) 
			);
			/*-~- Info -~-*/
			if(tally_config('type') == 'none'){ 
				$s_id = $s_section.'_info3';
				$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
				$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $s_id, 
					array(
						'label' => '',
						'section' => $s_section,
						'settings' => $s_id,
						'priority' => 10,
						'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over the Heading.',
					)) 
				);
			}
			$s_id = $s_section.'_enable';
			$s_label = __( 'Enabel Heading of this section', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Checkbox($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type' => 'checkbox',
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_title';
			$s_label = __( 'Title', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Text($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => '',
				)) 
			);
			$s_id = $s_section.'_des';
			$s_label = __( 'Description', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Textarea($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type' => 'textarea',
					'css_class' => '',
				)) 
			);
			
			$s_id = $s_section.'_type';
			$s_label = __( 'Type', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'select',
					'css_class' => 'biz',
					'choices'    => array(
						'-'     => __('None', 'tally_textdomain'),
						'one'     => __('Style 1', 'tally_textdomain'),
					),
				)) 
			);
			$s_id = $s_section.'_align';
			$s_label = __( 'Alignment', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Select($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'type'       => 'select',
					'css_class' => 'biz',
					'choices'    => array(
						'left'     => __('Left', 'tally_textdomain'),
						'right'     => __('Right', 'tally_textdomain'),
						'center'     => __('Center', 'tally_textdomain'),
						'none'     => __('None', 'tally_textdomain'),
					),
				)) 
			);
			
			$block_id = $s_section.'heading_tag';
			$block_label = __( 'Heading [Tag]: ', 'tally_textdomain' );
			$wp_customize->add_setting( $block_id, array('default' => 'h2', 'type' => 'theme_mod', 'sanitize_callback' => 'wp_kses_post') );
			$wp_customize->add_control( new WP_Customize_Control($wp_customize, $block_id, 
				array(
					'label' => $block_label,
					'section' => $s_section,
					'settings' => $block_id,
					'priority' => 10,
					'type'       => 'select',
					'choices'    => array(
						'h1'  => __('h1', 'tally_textdomain'),
						'h2'  => __('h2', 'tally_textdomain'),
						'h3'  => __('h3', 'tally_textdomain'),
						'h4'  => __('h4', 'tally_textdomain'),
						'h5'  => __('h5', 'tally_textdomain'),
						'h6'  => __('h6', 'tally_textdomain'),
						'p'  => __('p', 'tally_textdomain'),
						'strong'  => __('strong', 'tally_textdomain'),
					),
				)) 
			);
		endif;
		
		
		/*
			Building the blocks
		--------------------------------------------------------------------------*/
		if(is_array($tally_home['col_order'])){
			foreach($tally_home['col_order'] as $tally_home_col_order){
				if(is_array($tally_home['columns'])){
					foreach($tally_home['columns'] as $tally_home_column){
						if(is_array($tally_home_column['blocks'])){
							foreach($tally_home_column['blocks'] as $tally_home_column_block){
								if($tally_home_column_block['id'] == $tally_home_col_order){
									if(file_exists(tally_file_directory('home/blocks/'.$tally_home_column_block['name'].'/'.$tally_home_column_block['skin'].'/customizer.php'))){
										
										$block_section = $tally_home['id'].'_'.$tally_home_column_block['id'];
										$wp_customize->add_section( $block_section, 
											array(
												'title' => $tally_home_column_block['label'],
												'panel' => $tally_home['id'],
											) 
										);
										$block_id = $block_section.'_enable';
										$block_label = __( 'Enabel This: ', 'tally_textdomain' ).$tally_home_column_block['label'];
										$wp_customize->add_setting( 
											$block_id, 
											array('default' => tally_option_default($block_id),
											'type' => 'theme_mod',
											'sanitize_callback' => 'sanitize_text_field')
										);
										$wp_customize->add_control( new tally_Customize_Control_Checkbox($wp_customize, $block_id, 
											array(
												'label' => $block_label,
												'section' => $block_section,
												'settings' => $block_id,
												'priority' => 10,
												'type' => 'checkbox',
												'css_class' => 'biz',
											)) 
										);
										$block_id_prefix = $block_section.'_';
									  
										include(tally_file_directory('home/blocks/'.$tally_home_column_block['name'].'/'.$tally_home_column_block['skin'].'/customizer.php'));
									}
								}
							}
						}
					}
				}
			}
		}
		
		/*
			Building Seting sectionS
		--------------------------------------------------------------------------*/
		if($tally_home['colors'] == true):
			$s_section = $tally_home['id'].'_colors';
			$wp_customize->add_section( $s_section, 
				array(
					'title' => __( 'Colors', 'tally_textdomain' ),
					'panel' => $tally_home['id'],
				) 
			);
			
			/*-~- Info -~-*/
			if(tally_config('type') == 'none'){ 
				$s_id = $s_section.'_info4';
				$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
				$wp_customize->add_control( new tally_Customize_Control_TextBlock($wp_customize, $s_id, 
					array(
						'label' => '',
						'section' => $s_section,
						'settings' => $s_id,
						'priority' => 10,
						'description' => 'Check out the <a href="'.tally_config('theme_url').'" target="_blank" style="color:red;">PRO version</a> <br>for full control over the Colors of this section.',
					)) 
				);
			}
			
			$s_id = $s_section.'_headingColor';
			$s_label = __( 'Heading Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_headingAltColor';
			$s_label = __( 'Heading Alt Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_textColor';
			$s_label = __( 'Text Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_textMetaColor';
			$s_label = __( 'Text Meta Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_textAltColor';
			$s_label = __( 'Text Alt Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_borderColor';
			$s_label = __( 'Border Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
			$s_id = $s_section.'_borderAltColor';
			$s_label = __( 'Border Alt Color', 'tally_textdomain' );
			$wp_customize->add_setting( $s_id, array('default' => tally_option_default($s_id), 'type' => 'theme_mod', 'sanitize_callback' => 'sanitize_text_field') );
			$wp_customize->add_control( new tally_Customize_Control_Color($wp_customize, $s_id, 
				array(
					'label' => $s_label,
					'section' => $s_section,
					'settings' => $s_id,
					'priority' => 10,
					'css_class' => 'biz',
				)) 
			);
		endif;
	}
}
add_action( 'customize_register' , 'tally_home_customiser_builder' );
?>