<?php
/**
* Page Builder
* - Register Page Template
* - Add Page Builder Control
* - Save Page Builder Data
* - Admin Scripts
* 
* @since 1.0.0
* @author Kostas Zahariou <riou1791@gmail.com>
* @copyright Copyright (c) 2018
**/
/* === REGISTER PAGE TEMPLATE === */
/* Add page templates */
add_filter( 'theme_page_templates', 'riou_register_page_template' );
/*function hcf_register_meta_boxes() {
    add_meta_box( 'hcf-1', __( 'Hello Custom Field', 'hcf' ), 'riou_editor_callback', 'page' );
}
add_action( 'add_meta_boxes', 'hcf_register_meta_boxes' );*/
/**
* Register Page Template: Page Builder
* @since 1.0.0
*/
function riou_register_page_template( $templates ){
$templates['templates/page-builder.php'] = 'Page Builder';
return $templates;
}
/* === ADD PAGE BUILDER CONTROL === */
/* Add page builder form after editor */
add_action( 'edit_form_after_editor', 'riou_editor_callback', 10, 2 );
/**
* Page Builder Control
* Added after Content Editor in Page Edit Screen.
* @since 1.0.0
*/
function riou_editor_callback( $post ){
if( 'page' !== $post->post_type && 'conditions' !== $post->post_type && 'treatments' !== $post->post_type && 'tmimata' !== $post->post_type ){
return;
}

?>
<div id="riou-page-builderc" style="display:block !important">
  <div class="riou-actions">
    <a href="#" class="riou-add-container button-primary button-large" data-template="container">Add 1 Container
    </a>
  </div>
  <div class="riou-rows">
    <?php riou_render_rows( $post ); ?>
  </div>
  <div class="riou-templates" style="display:none;">
    <div class="riou-row riou-heading col-md-4">
      <div class="riou-row-title">
        <span class="riou-handle dashicons dashicons-sort">
        </span>
        <span class="riou-order">0
        </span>
        <span class="riou-row-title-text">1 heading
        </span>
        <span style="padding:5px; border:1px solid;" class="minus">-
        </span>
        <span style="padding:5px; border:1px solid;" class="plus">+
        </span>
        <span class="riou-remove dashicons dashicons-trash">
        </span>
        <span class="riou-clone dashicons dashicons-admin-page">
        </span>
      </div>
      <div class="riou-row-fields">
        <input class="riou-row-input" type="hidden" name="" data-field="key" value="">
        <textarea id="riou-new" class="riou-row-input" name="" data-field="content" placeholder="Add HTML here...">
        </textarea>
        <input class="riou-row-input" type="hidden" name="" data-field="type" value="heading">
        <input class="riou-row-input type2" type="hidden" name="" data-field="text" value="col-md-4">
        <select class="riou-row-input sel" data-field="sel">
          <option value="1">1
          </option>
          <option value="2">2
          </option>
        </select>
      </div>
    </div>
    <?php wp_nonce_field( "riou_nonce_action", "riou_nonce" );  ?>
    <?php //wp_editor( '', 'riou1content', array( 'textarea_name' => 'txtmessage', 'media_buttons' => false, 'tinymce_adv' => array( 'width' => '300', 'theme_advanced_buttons1' => 'formatselect,forecolor,|,bold,italic,underline,|,bullist,numlist,blockquote,|,justifyleft,justifycenter,justifyright,justifyfull,|,link,unlink,|,spellchecker,wp_fullscreen,wp_adv' ) ) );   ?>
  </div>
  <?php
}

add_action( 'save_post', 'riou_save_post', 10, 2 );

function riou_save_post( $post_id, $post ){

$request = stripslashes_deep( $_POST );

if ( ! isset( $request['riou_nonce'] ) || ! wp_verify_nonce( $request['riou_nonce'], 'riou_nonce_action' ) ){
return $post_id;
}

if ( defined('DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
return $post_id;
}

$post_type = get_post_type_object( $post->post_type );
if ( ('page' != $post->post_type && 'conditions' != $post->post_type && 'treatments' != $post->post_type && 'tmimata' != $post->post_type) || !current_user_can( $post_type->cap->edit_post, $post_id ) ){
return $post_id;
}

$saved_data = get_post_meta( $post_id, 'riou', true );

$submitted_data = isset( $request['riou'] ) ?  $request['riou']  : null;

if ( $submitted_data && '' == $saved_data ){
add_post_meta( $post_id, 'riou', $submitted_data, true );
}

elseif( $submitted_data && ( $submitted_data != $saved_data ) ){
update_post_meta( $post_id, 'riou', $submitted_data );
}

elseif ( empty( $submitted_data ) && $saved_data ){
delete_post_meta( $post_id, 'riou' );
}

$page_template = isset( $request['page_template'] ) ? esc_attr( $request['page_template'] ) : null;


$pb_content = riou_format_post_content_data( $submitted_data );

$this_post = array(
'ID'           => $post_id,

'post_content' =>  'post_content', $pb_content, $post_id, 'db' ,
);

remove_action( 'save_post', 'riou_save_post' );
wp_update_post( $this_post );
add_action( 'save_post', 'riou_save_post' );

}

function riou_format_post_content_data( $row_datas ){

if( !$row_datas ){
return '';
}

$content = '';

foreach( $row_datas as $order => $row_data ){
$order = intval( $order );

$content .= $row_data['content'] . "\r\n\r\n";

}
return $content;
}

function riou_render_rows( $post ){

$row_datas = get_post_meta( $post->ID, 'riou', true ) ;

$default_message = 'Please add row to start!';

if( !$row_datas ){
echo '<p class="riou-rows-message">' . $default_message . '</p>';
return;
}

else{
echo '<p class="riou-rows-message" style="display:none;">' . $default_message . '</p>';
}

$x=0; 
$is_container = false;
foreach( $row_datas as $order => $row_data ){
$order = intval( $order );

if( 'container' == $row_data['type'] ){
$number = $row_data['key'];
$is_container = true;

?>

  <div class="riou-row riou-container <?php echo $row_data['text'];?> <?php echo $row_data['the-class'];?>" >
    <div class="riou-row-title">
      <span class="riou-handle dashicons dashicons-sort">
      </span>
      <span class="riou-order">
        <?php echo $order; ?>
      </span>
      <span class="riou-row-title-text">Section
      </span>
      <span style="padding:5px; border:1px solid;" class="minus">-
      </span>
      <span style="padding:5px; border:1px solid;" class="plus">+
      </span>
      <span class="riou-remove dashicons dashicons-trash">
      </span>
      <span class="riou-clone dashicons dashicons-admin-page">
        </span>
    </div>
    <div class="riou-row-fields">
    <input class="riou-row-input" type="text" name="" data-field="the-class" value="<?php echo $row_data['the-class'];?>">
      <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
      <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="container">
      <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text" value="<?php echo $row_data['text'];?>">
    </div>
    <?php
$y=0; 
$is_col = false;
?>
    <?php foreach( $row_datas as $order => $row_data ){
if( 'col-1' == $row_data['type'] && $row_data['key'] == $number ){ ?>
    <?php $is_col = true; $number2 = $row_data['key2'];?>
    <div class="riou-row riou-col-1 <?php echo $row_data['text'];?>">
      <div class='riou-inner'>
      <div class="riou-row-title">
        <span class="riou-handle-row dashicons dashicons-sort">
        </span>
        <span class="riou-order">
          <?php echo $order; ?>
        </span>
        <span class="riou-row-title-text">Row
        </span>
        <span style="padding:5px; border:1px solid;" class="minus">-
        </span>
        <span style="padding:5px; border:1px solid;" class="plus">+
        </span>
        <span class="riou-remove dashicons dashicons-trash">
        </span>
        <span class="riou-clone dashicons dashicons-admin-page">
        </span>
      </div>
      <div class="riou-row-fields">
        <input class="riou-row-input key2" type="hidden" name="riou[<?php echo $order; ?>][key2]" data-field="key2" value="<?php echo $y; ?>">
        <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
        <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="col-1">
        <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text" value="<?php echo $row_data['text'];?>">
      </div>
      <div class="riou-actions">
        <a href="#" class="riou-add-text button-primary button-large" data-template="col-1">Column
        </a>
        <!--<a href="#" class="riou-add-row button-primary button-large" data-template="heading">Heading
        </a>-->
        <a href="#" class="riou-add-button button-primary button-large" data-template="col-1">Button
        </a>
        <a href="#" class="riou-add-image button-primary button-large" data-template="image">Image
        </a>
        <a href="#" class="riou-add-image-gallery button-primary button-large" data-template="imagegallery">Image Gallery
        </a>
        <a href="#" class="riou-add-faq button-primary button-large" data-template="faq">FAQ
        </a>
      </div>
      <?php
foreach( $row_datas as $order => $row_data ){
if( 'image' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number ){
?>
      <div class="riou-row riou-image riou-elem <?php echo $row_data['text'];?>">
        <div class='riou-inner'>
        <div class="riou-row-title">
          <span class="riou-handle-elem dashicons dashicons-sort">
          </span>
          <span class="riou-order">
            <?php echo $order; ?>
          </span>
          <span class="riou-row-title-text">Image
          </span>
          <span style="padding:5px; border:1px solid;" class="minus">-
          </span>
          <span style="padding:5px; border:1px solid;" class="plus">+
          </span>
          <span class="riou-remove dashicons dashicons-trash">
          </span>
          <span class="riou-clone dashicons dashicons-admin-page">
        </span>
        </div>
        <div class="riou-row-fields">
          <input class="riou-row-input key2" type="hidden" name="riou[<?php echo $order; ?>][key2]" data-field="key2" value="<?php echo $y; ?>">
          <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
          <textarea class="riou-row-input image-url " name="riou[<?php echo $order; ?>][content]" data-field="content" placeholder="Add HTML here...">
            <?php echo esc_textarea( $row_data['content'] ); ?>
          </textarea>
          <input type="button" class="upload-button" data-target="" value="Upload Image" />
          <img class="image-preview" style="max-width:100%;"  src="<?php echo esc_textarea( $row_data['content'] ); ?>"/>
          <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="image">
          <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text"  value="<?php echo $row_data['text'];?>">
        </div>
    </div>
      </div>
      <?php
}

if( 'imagegallery' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number ){
?>
      <div class="riou-row riou-image-gallery riou-elem <?php echo $row_data['text'];?>">
        <div class='riou-inner'>
        <div class="riou-row-title">
          <span class="riou-handle-elem dashicons dashicons-sort">
          </span>
          <span class="riou-order">
            <?php echo $order; ?>
          </span>
          <span class="riou-row-title-text">Image Gallery
          </span>
          <span style="padding:5px; border:1px solid;" class="minus">-
          </span>
          <span style="padding:5px; border:1px solid;" class="plus">+
          </span>
          <span class="riou-remove dashicons dashicons-trash">
          </span>
          <span class="riou-clone dashicons dashicons-admin-page">
        </span>
        </div>
        <div class="riou-row-fields">
          <input class="riou-row-input key2" type="hidden" name="riou[<?php echo $order; ?>][key2]" data-field="key2" value="<?php echo $y; ?>">
          <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
          <textarea class="riou-row-input image-gallery-url " name="riou[<?php echo $order; ?>][content]" data-field="content" placeholder="Add HTML here...">
            <?php echo esc_textarea( $row_data['content'] ); ?>
          </textarea>
          <input type="button" class="upload-button-gallery" data-target="" value="Upload Image Gallery" />
          <div class="image-preview"> <?php echo do_shortcode('[gallery include="' . $row_data['content'] . '" size="medium" columns="3"]'); ?></div>
          <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="imagegallery">
          <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text"  value="<?php echo $row_data['text'];?>">
        </div>
    </div>
      </div>
      <?php
}

if( 'text' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number ){
?>
      <div class="riou-row riou-text riou-elem <?php echo $row_data['text'];?>">
        <div class="riou-row-title">
          <span class="riou-handle-elem dashicons dashicons-sort">
          </span>
          <span class="riou-order">
            <?php echo $order; //wp_editor( 'test', 'riou'.$order, array( 'media_buttons' => false, 'tinymce_adv' => array( 'width' => '300', 'theme_advanced_buttons1' => 'formatselect,forecolor,|,bold,italic,underline,|,bullist,numlist,blockquote,|,justifyleft,justifycenter,justifyright,justifyfull,|,link,unlink,|,spellchecker,wp_fullscreen,wp_adv' ) ) ); ?>
          </span>
          <span class="riou-row-title-text">Column
          </span>
          <span style="padding:5px; border:1px solid;" class="minus">-
          </span>
          <span style="padding:5px; border:1px solid;" class="plus">+
          </span>
          <span class="riou-remove dashicons dashicons-trash">
          </span>
          <span class="riou-clone dashicons dashicons-admin-page">
        </span>
        </div>
        <div class="riou-row-fields">
          <input class="riou-row-input" type="text" name="" data-field="the-elem-class" value="<?php echo $row_data['the-elem-class'];?>">
          <input class="riou-row-input key2" type="hidden" name="riou[<?php echo $order; ?>][key2]" data-field="key2" value="<?php echo $y; ?>">
          <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
          <!--<textarea  id="riou<?php echo $order ?>" class="riou-row-input " name="riou[<?php echo $order; ?>][content]" data-field="content" placeholder="Add HTML here...">
            <?php //echo esc_textarea( $row_data['content'] ); ?>
          </textarea>-->
          <?php  wp_editor( $row_data['content'], 'riou'.$order, array('textarea_name' => 'riou['.$order.'][content]', 'media_buttons' => false, 'tinymce_adv' => array( 'width' => '300', 'theme_advanced_buttons1' => 'formatselect,forecolor,|,bold,italic,underline,|,bullist,numlist,blockquote,|,justifyleft,justifycenter,justifyright,justifyfull,|,link,unlink,|,spellchecker,wp_fullscreen,wp_adv' ) ) );  ?>
          <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="text">
          <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text"  value="<?php echo $row_data['text'];?>">
        </div>
      </div>
      <?php

?>
      <?php
}


if( 'button' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number ){
?>
      <div class="riou-row riou-text riou-elem <?php echo $row_data['text']; ?> <?php echo $row_data['the-elem-class'];?>">
        <div class="riou-row-title">
          <span class="riou-handle dashicons dashicons-sort">
          </span>
          <span class="riou-order">
            <?php echo $order; //wp_editor( '', 'riou'.$order, array( 'textarea_name' => 'txtmessage', 'media_buttons' => false, 'tinymce_adv' => array( 'width' => '300', 'theme_advanced_buttons1' => 'formatselect,forecolor,|,bold,italic,underline,|,bullist,numlist,blockquote,|,justifyleft,justifycenter,justifyright,justifyfull,|,link,unlink,|,spellchecker,wp_fullscreen,wp_adv' ) ) );  ?>
          </span>
          <span class="riou-row-title-text">Button
          </span>
          <span style="padding:5px; border:1px solid;" class="minus">-
          </span>
          <span style="padding:5px; border:1px solid;" class="plus">+
          </span>
          <span class="riou-remove dashicons dashicons-trash">
          </span>
        </div>
        <div class="riou-row-fields">
          <input class="riou-row-input" type="text" name="" data-field="the-elem-class" value="<?php echo $row_data['the-elem-class'];?>">
          <input class="riou-row-input key2" type="hidden" name="riou[<?php echo $order; ?>][key2]" data-field="key2" value="<?php echo $y; ?>">
          <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
          <input id="riou<?php echo $order ?>" class="riou-row-input" name="riou[<?php echo $order; ?>][buttonlink]" data-field="buttonlink" value="<?php echo $row_data['buttonlink'] ?>" placeholder="Link..." />
          <input id="riou<?php echo $order ?>" class="riou-row-input" name="riou[<?php echo $order; ?>][buttontext]" data-field="buttontext" value="<?php echo $row_data['buttontext'] ?>" placeholder="Text..." />
          <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="button">
          <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text"  value="<?php echo $row_data['text'];?>">
        </div>
      </div>
      <?php

?>
      <?php
}

if( 'faq' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number ){
?>
      <div class="riou-row riou-text riou-elem <?php echo $row_data['text']; ?> <?php echo $row_data['the-elem-class'];?>">
        <div class="riou-row-title">
          <span class="riou-handle dashicons dashicons-sort">
          </span>
          <span class="riou-order">
            <?php echo $order; //wp_editor( '', 'riou'.$order, array( 'textarea_name' => 'txtmessage', 'media_buttons' => false, 'tinymce_adv' => array( 'width' => '300', 'theme_advanced_buttons1' => 'formatselect,forecolor,|,bold,italic,underline,|,bullist,numlist,blockquote,|,justifyleft,justifycenter,justifyright,justifyfull,|,link,unlink,|,spellchecker,wp_fullscreen,wp_adv' ) ) );  ?>
          </span>
          <span class="riou-row-title-text">FAQ
          </span>
          <span style="padding:5px; border:1px solid;" class="minus">-
          </span>
          <span style="padding:5px; border:1px solid;" class="plus">+
          </span>
          <span class="riou-remove dashicons dashicons-trash">
          </span>
        </div>
        <div class="riou-row-fields">
          <input class="riou-row-input" type="text" name="" data-field="the-elem-class" value="<?php echo $row_data['the-elem-class'];?>">
          <input class="riou-row-input key2" type="hidden" name="riou[<?php echo $order; ?>][key2]" data-field="key2" value="<?php echo $y; ?>">
          <input class="riou-row-input key" type="hidden" name="riou[<?php echo $order; ?>][key]" data-field="key" value="<?php echo $x; ?>">
          <input id="riou<?php echo $order ?>" class="riou-row-input" name="riou[<?php echo $order; ?>][question]" data-field="question" value="<?php echo $row_data['question'] ?>" placeholder="Question..." />
          <textarea  id="riou<?php echo $order ?>" class="riou-row-input " name="riou[<?php echo $order; ?>][answer]" data-field="answer" placeholder="Answer...">
            <?php echo trim(esc_textarea( trim($row_data['answer']) )); ?>
          </textarea>
          <input class="riou-row-input" type="hidden" name="riou[<?php echo $order; ?>][type]" data-field="type" value="faq">
          <input class="riou-row-input type2" type="hidden" name="riou[<?php echo $order; ?>][text]" data-field="text"  value="<?php echo $row_data['text'];?>">
        </div>
      </div>
      <?php

?>
      <?php
}

}
?>
</div>
    </div>
    <?php if ($is_col==true ) {$y++;$is_col == false;}
}
} 
foreach( $row_datas as $order => $row_data ){
}
if ($is_container == true) {
$x++;
$is_container == false;
} else {
$continue;
} 
?>
    <div class="riou-actions"> 
      <a href="#" class="riou-add-row button-primary button-large" data-template="col-1">Add 1 Row
      </a> 
    </div>
  </div>
  <?php
}

}
}

add_action( 'admin_enqueue_scripts', 'riou_admin_scripts' );

function riou_admin_scripts( $hook_suffix ){
global $post_type;
if( ('page' == $post_type || 'conditions' == $post_type || 'treatments' == $post_type || 'tmimata' == $post_type) && in_array( $hook_suffix, array( 'post.php', 'post-new.php' ) ) ){
wp_enqueue_script( 'riou-admin-editor-toggle', RIOUBUILDER_URI . 'assets/admin-editor-toggle.js', array( 'jquery' ), RIOUBUILDER_VERSION );

wp_enqueue_style( 'riou-admin', RIOUBUILDER_URI. 'assets/admin-page-builder.css', array(), RIOUBUILDER_VERSION );
wp_enqueue_script( 'riou-admin', RIOUBUILDER_URI. 'assets/admin-page-builder.js', array( 'jquery', 'jquery-ui-sortable' ), 'RIOUBUILDER', true );
}
}
function my_enqueue($hook) {


wp_enqueue_media();
wp_enqueue_script('my_custom_script', plugin_dir_url( __FILE__ ) . '/myscript.js');
wp_enqueue_script('my_custom_script2', plugin_dir_url( __FILE__ ) . '/media-lib-uploader.js');
}
add_action('admin_enqueue_scripts', 'my_enqueue');