/**
 * f(x) Page Builder Base Admin JS
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @link https://shellcreeper.com/wp-page-builder-plugin-from-scratch/
 * @author David Chandra Purnama <david@genbumedia.com>
 * @copyright Copyright (c) 2016, Genbu Media
**/
jQuery( document ).ready( function( $ ){
var cnt=0;
	/* Function: Update Order */
	function riou_UpdateOrder(){

		/* In each of rows */
		$('.riou-rows .riou-row').each( function(i){

			/* Increase num by 1 to avoid "0" as first index. */
			var num = i + 1;

			/* Update order number in row title */
			$( this ).find( '.riou-order' ).text( num );

			/* In each input in the row */
			$( this ).find( '.riou-row-input' ).each( function(i) {

				/* Get field id for this input */
				var field = $( this ).attr( 'data-field' );

				/* Update name attribute with order and field name.  */
				$( this ).attr( 'name', 'riou[' + num + '][' + field + ']');
			});
		});
	}

	/* Update Order on Page load */
	riou_UpdateOrder();

	/* Make Row Sortable */
	$( '.riou-rows' ).sortable({
		handle: '.riou-handle',
		cursor: 'grabbing',
		stop: function( e, ui ) {
			riou_UpdateOrder();
		},
	});

	/* Add Row */
	$( 'body' ).on( 'click', '.riou-add-container', function(e){
		e.preventDefault();
 
		 /* Target the template. */
		//var template = '.riou-templates > .riou-' + $( this ).attr( 'data-template' );
		var containers = $('.riou-container').length;

		var template = '<div class="riou-row riou-container col-md-12" style="background-color:green;"> <div class="riou-row-title"> <div class="riou-row-fields"><input class="riou-row-input" type="text" name="" data-field="the-class" value=""> <input class="riou-row-input key" type="hidden" name="" data-field="key" value="'+containers+'"> <input class="riou-row-input" type="hidden" name="" data-field="type" value="container"> <input class="riou-row-input type2" type="hidden" name="" data-field="text" value=""> </div> <span class="riou-handle dashicons dashicons-sort"></span> <span class="riou-order">0</span> <span class="riou-row-title-text">1 Column</span> <span style="padding:5px; border:1px solid;" class="minus">-</span> <span style="padding:5px; border:1px solid;" class="plus">+</span> <span class="riou-remove dashicons dashicons-trash"></span> </div><!-- .riou-row-title --> <div class="riou-actions"> <a href="#" class="riou-add-row button-primary button-large" data-template="col-1">Add 1 Row</a> </div><!-- .riou-actions --> </div>';

		/* Clone the template and add it. */
		$( template ).clone().appendTo( '.riou-rows' );

		/* Hide Empty Row Message */
		$( '.riou-rows-message' ).hide();

		/* Update Order */
		riou_UpdateOrder();
	});

	$( 'body' ).on( 'click', '.riou-add-row', function(e){
		e.preventDefault();

		var containers = $('.riou-container').length-1;
		var cont = $(this).closest('.riou-container');
        var number = cont.find('.key').attr('value');
        var rows = cont.find('.riou-col-1').length;
		 /* Target the template. */
		var template = '<div class="riou-row riou-col-1 col-md-4" style="background-color:lightgrey;"><div class="riou-row-title"> <span class="riou-handle dashicons dashicons-sort"></span> <span class="riou-order">0</span> <span class="riou-row-title-text">1 Column</span> <span style="padding:5px; border:1px solid;" class="minus">-</span> <span style="padding:5px; border:1px solid;" class="plus">+</span> <span class="riou-remove dashicons dashicons-trash"></span> </div><!-- .riou-row-title --> <div class="riou-actions"> <a href="#" class="riou-add-text button-primary button-large" data-template="text">Add 1 Column</a> <a href="#" class="riou-add-row button-primary button-large" data-template="heading">Add 1 Heading</a> <a href="#" class="riou-add-image button-primary button-large" data-template="image">Add 1 Image</a> </div> <div class="riou-row-fields"><input class="riou-row-input key2" type="hidden" name="" data-field="key2" value="'+rows+'">  <input class="riou-row-input" type="hidden" name="" data-field="key" value="'+number+'"> <input class="riou-row-input" type="hidden" name="" data-field="type" value="col-1"> <input class="riou-row-input type2" type="hidden" name="" data-field="text" value="col-md-4"> </div><!-- .riou-row-fields --></div>';

		/* Clone the template and add it. */
		$( template ).clone().appendTo( $( this ).closest('.riou-container') );

		/* Hide Empty Row Message */
		$( '.riou-rows-message' ).hide();

		/* Update Order */
		riou_UpdateOrder();
	});

	$( 'body' ).on( 'click', '.riou-add-image', function(e){
		e.preventDefault();
		var containers = $('.riou-container').length-1;
		var cont = $(this).closest('.riou-container');
        var number = cont.find('.key').attr('value');
		var ro = $(this).closest('.riou-col-1');
        var number2 = ro.find('.key2').attr('value');
 
		 /* Target the template. */
		var template = '<div class="riou-row riou-image riou-elem col-md-4"> <div class="riou-row-title"> <span class="riou-handle dashicons dashicons-sort"></span> <span class="riou-order">0</span> <span class="riou-row-title-text">1 image</span> <span style="padding:5px; border:1px solid;" class="minus">-</span> <span style="padding:5px; border:1px solid;" class="plus">+</span> <span class="riou-remove dashicons dashicons-trash"></span> </div><!-- .riou-row-title --> <div class="riou-row-fields"> <textarea class="riou-row-input image-url" name="" data-field="content" placeholder="Add HTML here..."></textarea> <input type="button" class="upload-button" value="Upload Image" /> <img class="image-preview" style="max-width:100%;" src=""/> <input class="riou-row-input" type="hidden" name="" data-field="key" value="'+number+'"><input class="riou-row-input key2" type="hidden" name="" data-field="key2" value="'+number2+'"> <input class="riou-row-input" type="hidden" name="" data-field="type" value="image"> <input class="riou-row-input type2" type="hidden" name="" data-field="text" value="col-md-4"> </div><!-- .riou-row-fields --> </div>'

		/* Clone the template and add it. */
		$( template ).clone().appendTo( $( this ).closest('.riou-col-1') );

		/* Hide Empty Row Message */
		$( '.riou-rows-message' ).hide();

		/* Update Order */
		riou_UpdateOrder();
	});

	$( 'body' ).on( 'click', '.riou-add-text', function(e){
		e.preventDefault();
		cnt++;
		var containers = $('.riou-container').length-1;
		var cont = $(this).closest('.riou-container');
        var number = cont.find('.key').attr('value');
		var ro = $(this).closest('.riou-col-1');
        var number2 = ro.find('.key2').attr('value');
 
		 /* Target the template. */
		var template = '<div class="riou-row riou-text riou-elem col-md-4"> <div class="riou-row-title"> <span class="riou-handle dashicons dashicons-sort"></span> <span class="riou-order">0</span> <span class="riou-row-title-text">1 text</span> <span style="padding:5px; border:1px solid;" class="minus">-</span> <span style="padding:5px; border:1px solid;" class="plus">+</span> <span class="riou-remove dashicons dashicons-trash"></span> </div><!-- .riou-row-title --> <div class="riou-row-fields"> <textarea id="riou'+cnt+'content" class="riou-row-input " name="" data-field="content" placeholder="Add HTML here..."></textarea> <input class="riou-row-input" type="hidden" name="" data-field="key" value="'+number+'"><input class="riou-row-input key2" type="hidden" name="" data-field="key2" value="'+number2+'"> <input class="riou-row-input" type="hidden" name="" data-field="type" value="text"> <input class="riou-row-input type2" type="hidden" name="" data-field="text" value="col-md-4"> </div><!-- .riou-row-fields --> </div>';
        
		/* Clone the template and add it. */
		$( template ).clone().appendTo( $( this ).closest('.riou-col-1') );

		/* Hide Empty Row Message */
		$( '.riou-rows-message' ).hide();
		/* Update Order */
		riou_UpdateOrder();
	});

	/* Hide/Show Empty Row Message On Page Load */
	if( $( '.riou-rows > .riou-row' ).length ){
		$( '.riou-rows-message' ).hide();
	}
	else{
		$( '.riou-rows-message' ).show();
	}

	/* Delete Row */
	$( 'body' ).on( 'click', '.riou-remove', function(e){
		e.preventDefault();

		/* Delete Row */
		$( this ).closest( '.riou-row' ).remove();
		
		/* Show Empty Message When Applicable. */
		if( ! $( '.riou-rows > .riou-row' ).length ){
			$( '.riou-rows-message' ).show();
		}

		/* Update Order */
		riou_UpdateOrder();
	});

});
