<?php
/**
 * Front End Output
 * @since 1.0.0
 **/

/* Filter Content as early as possible, but after all WP code filter runs. */
add_filter('the_content', 'riou_filter_content', 10.5);

/**
 * Filter Content
 * @since 1.0.0
 **/
function riou_filter_content($content)
{
    
    /* In single page when page builder template selected. */
   
        
        /* Add content with shortcode, autoembed, responsive image, etc. */
        $content = riou_default_content_filter(riou_get_content());
    
    
    /* Return content */
    return $content;
}

/**
 * Page Builder Content Output
 * This need to be use in the loop.
 * @since 1.0.0
 **/
function riou_get_content()
{
    
    /* Get saved rows data and sanitize it */
    $row_datas = get_post_meta(get_the_ID(), 'riou', true);
    
    /* return if no rows data */
    if (!$row_datas) {
        return '';
    }
    
    
    $content = '';
    
    $x            = 0;
    $is_container = false;
    foreach ($row_datas as $order => $row_data) {
        $order = intval($order);
        
        if ('container' == $row_data['type']) {
            $number       = $row_data['key'];
            $is_container = true;
            $content .= '<div class="section '. $row_data['the-class'] .'"><div class="riou-row ' . $row_data['key'] . ' riou-row-' . $order . ' riou-container container ' . $row_data['text'] . '">' . "\r\n";
            $content .= '<div class="riou-row-inner row">' . "\r\n";
            
            
            $y      = 0;
            $is_col = false;
            
            foreach ($row_datas as $order => $row_data) {
                if ('col-1' == $row_data['type'] && $row_data['key'] == $number) {
                    
                    $is_col  = true;
                    $number2 = $row_data['key2'];
                    
                    if ('col-1' == $row_data['type']) {
                        $content .= '<div class="riou-row riou-row-' . $order . ' riou-col-1 ' . $row_data['text'] . '">' . "\r\n";
                        
                        
                        foreach ($row_datas as $order => $row_data) {
                            if ('image' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number) {
                                $content .= '<div class="riou-row riou-row-' . $order . ' riou-image ' . $row_data['text'] . '">' . "\r\n";
                                $content .= '<img class="row-content" src="' . $row_data['content'] . '">' . "\r\n\r\n";
                                $content .= '</>' . "\r\n";
                                $content .= '</div>' . "\r\n\r\n";
                            }
                            
                            if ('text' == $row_data['type'] && $row_data['key2'] == $number2 && $row_data['key'] == $number) {
                                $content .= '<div class="riou-row riou-row-' . $order . ' riou-text ' . $row_data['text'] .' '. $row_data['the-elem-class'] .'">' . "\r\n";
                                $content .= '<div class="row-content">' . $row_data['content'] . '</div>' . "\r\n\r\n";
                                $content .= '</>' . "\r\n";
                                $content .= '</div>' . "\r\n\r\n";
                            }
                        }
                        
                        
                        
                        
                        $content .= '</div>' . "\r\n\r\n";
                        if ($is_col == true) {
                            $y++;
                            $is_col == false;
                        }
                    }
                    
                }
            }
            
            if ($is_container == true) {
                $x++;
                $is_container == false;
            } else {
                $continue;
            }
            $content .= '</div></div></div>' . "\r\n\r\n";
        }
        
        
        
        
        /*if( 'heading' == $row_data['type'] ){
        $content .= '<div class="riou-row riou-row-' . $order . ' riou-heading '. $row_data['text'] .'">' . "\r\n";
        $content .= '<h'.$row_data['sel'].' class="row-content">' . "\r\n\r\n";
        $content .= $row_data['content'] . "\r\n\r\n";
        $content .= '</h'.$row_data['sel'].'>' . "\r\n";
        $content .= '</div>' . "\r\n\r\n";
        }
        
        if( 'image' == $row_data['type'] ){
        $content .= '<div class="riou-row riou-row-' . $order . ' riou-image '. $row_data['text'] .'">' . "\r\n";
        $content .= '<img class="row-content" src="'.$row_data['content'].'">' . "\r\n\r\n";
        $content .= '</>' . "\r\n";
        $content .= '</div>' . "\r\n\r\n";
        }*/
    }
    return $content;
}


/* === FRONT-END SCRIPTS === */

/* Enqueue Script */
add_action('wp_enqueue_scripts', 'riou_front_end_scripts');

/**
 * Admin Scripts
 * @since 1.0.0
 */
function riou_front_end_scripts()
{
    
    /* In a page using page builder */
    if (is_page() && ('templates/page-builder.php' == get_page_template_slug(get_queried_object_id()))) {
        
        /* Enqueue CSS & JS For Page Builder */
        wp_enqueue_style('fx-page-builder', RIOUBUILDER_URI . 'assets/page-builder.css', array(), RIOUBUILDER_VERSION);
    }
}