<?php

/**
 * Fired during plugin activation
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Plugin_Name
 * @subpackage Plugin_Name/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Plugin_Name
 * @subpackage Plugin_Name/includes
 * @author     Your Name <email@example.com>
 */
class GY_Post {
    function create_me($type) {
		$the_query = new WP_Query(array('post_type' => array('type')));
    while ($the_query->have_posts()) : $the_query->the_post();
        global $post;
        //*************************get the values
        $cp_public = get_post_meta($post->ID, 'cp_public', true);
        if ($cp_public == "on") {
            $cp_public = true;
        } else {
            $cp_public = false;
        }
        $cp_publicly_queryable = get_post_meta($post->ID, 'cp_publicly_queryable', true);
        if ($cp_publicly_queryable == "on") {
            $cp_publicly_queryable = true;
        } else {
            $cp_publicly_queryable = false;
        }
        $cp_show_ui = get_post_meta($post->ID, 'cp_show_ui', true);
        if ($cp_show_ui == "on") {
            $cp_show_ui = true;
        } else {
            $cp_show_ui = false;
        }
        $cp_show_in_menu = get_post_meta($post->ID, 'cp_show_in_menu', true); //
        if ($cp_show_in_menu == "on") {
            $cp_show_in_menu = true;
        } else {
            $cp_show_in_menu = false;
        }
        $cp_query_var = get_post_meta($post->ID, 'cp_query_var', true); //
        if ($cp_query_var == "on") {
            $cp_query_var = true;
        } else {
            $cp_query_var = false;
        }
        $cp_rewrite = get_post_meta($post->ID, 'cp_rewrite', true); //
        if ($cp_rewrite == "on") {
            $cp_rewrite = true;
        } else {
            $cp_rewrite = false;
        }
        $cp_has_archive = get_post_meta($post->ID, 'cp_has_archive', true); //
        if ($cp_has_archive == "on") {
            $cp_has_archive = true;
        } else {
            $cp_has_archive = false;
        }
        $cp_hierarchical = get_post_meta($post->ID, 'cp_hierarchical', true);
        if ($cp_hierarchical == "on") {
            $cp_hierarchical = true;
        } else {
            $cp_hierarchical = false;
        }
        $cp_capability_type = get_post_meta($post->ID, 'cp_capability_type', true);
        $cp_menu_position = get_post_meta($post->ID, 'cp_menu_position', true);
        $cp_s_title = get_post_meta($post->ID, 'cp_s_title', true);
        if ($cp_s_title == "on") {
            $cp_s[] = 'title';
        }
        $cp_s_editor = get_post_meta($post->ID, 'cp_s_editor', true);
        if ($cp_s_editor == "on") {
            $cp_s[] = 'editor';
        }
        $cp_s_author = get_post_meta($post->ID, 'cp_s_author', true);
        if ($cp_s_author == "on") {
            $cp_s[] = 'author';
        }
        $cp_s_thumbnail = get_post_meta($post->ID, 'cp_s_thumbnail', true);
        if ($cp_s_thumbnail == "on") {
            $cp_s[] = 'thumbnail';
        }
        $cp_s_excerpt = get_post_meta($post->ID, 'cp_s_excerpt', true);
        if ($cp_s_excerpt == "on") {
            array_push($cp_s, 'excerpt');
        }
        $cp_s_comments = get_post_meta($post->ID, 'cp_s_comments', true);
        if ($cp_s_comments == "on") {
            array_push($cp_s, 'comments');
        }
        $cp_general_name = get_post_meta($post->ID, 'cp_general_name', true);
        $cp_singular_name = get_post_meta($post->ID, 'cp_singular_name', true);
        $cp_add_new = get_post_meta($post->ID, 'cp_add_new', true);
        $cp_add_new_item = get_post_meta($post->ID, 'cp_add_new_item', true);
        $cp_edit_item = get_post_meta($post->ID, 'cp_edit_item', true);
        $cp_new_item = get_post_meta($post->ID, 'cp_new_item', true);
        $cp_all_items = get_post_meta($post->ID, 'cp_all_items', true);
        $cp_view_item = get_post_meta($post->ID, 'cp_view_item', true);
        $cp_search_items = get_post_meta($post->ID, 'cp_search_items', true);
        $cp_not_found = get_post_meta($post->ID, 'cp_not_found', true);
        $cp_not_found_in_trash = get_post_meta($post->ID, 'cp_not_found_in_trash', true);
        $cp_parent_item_colon = get_post_meta($post->ID, 'cp_parent_item_colon', true);

        $labels = array(
            'name' => _x(get_the_title($post->ID), 'post type general name'),
            'singular_name' => _x($cp_singular_name, 'post type singular name'),
            'add_new' => _x($cp_add_new, get_the_title($post->ID)),
            'add_new_item' => __($cp_add_new_item),
            'edit_item' => __($cp_edit_item),
            'new_item' => __($cp_new_item),
            'all_items' => __($cp_all_items),
            'view_item' => __($cp_view_item),
            'search_items' => __($cp_search_items),
            'not_found' => __($cp_not_found),
            'not_found_in_trash' => __($cp_not_found_in_trash),
            'parent_item_colon' => __($cp_parent_item_colon),
            'menu_name' => __(get_the_title($post->ID))
        );
        $args = array(
            'labels' => $labels,
            'public' => $cp_public,
            'publicly_queryable' => $cp_publicly_queryable,
            'show_ui' => $cp_show_ui,
            'show_in_menu' => $cp_show_in_menu,
            'query_var' => $cp_query_var,
            'rewrite' => $cp_rewrite,
            'capability_type' => 'post',
            'has_archive' => $cp_has_archive,
            'hierarchical' => $cp_hierarchical,
            'menu_position' => $cp_menu_position,
            'supports' => $cp_s
        );
        register_post_type(get_the_title($post->ID), $args);

    endwhile;
	}



}
