<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://example.com
 * @since             1.0.0
 * @package           Plugin_Name
 *
 * @wordpress-plugin
 * Plugin Name:       WP Toolkit
 * Plugin URI:        http://example.com/plugin-name-uri/
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Your Name or Your Company
 * Author URI:        http://example.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       plugin-name
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}



/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PLUGIN_NAME_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-plugin-name-activator.php
 */
function activate_plugin_name() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-plugin-name-activator.php';
	Plugin_Name_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-plugin-name-deactivator.php
 */
function deactivate_plugin_name() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-plugin-name-deactivator.php';
	Plugin_Name_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_plugin_name' );
register_deactivation_hook( __FILE__, 'deactivate_plugin_name' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-plugin-name.php';
require plugin_dir_path( __FILE__ ) . 'includes/class-gy-post-functions.php';

function create_shortcode() {
  register_post_type( 'shortcode',
    array(
      'labels' => array(
        'name' => __( 'Shortcodes' ),
        'singular_name' => __( 'Shortcodes' ),
      ),
      'public' => true,
      'has_archive' => true,
	  'taxonomies'  => array( 'cat-shortcode' ),
	  'menu_icon'           => 'dashicons-format-aside',
	  'supports' => array( 'title')
    )
  );
}

add_action( 'init', 'create_shortcode' );

function create_post_type() {
  register_post_type( 'type',
    array(
      'labels' => array(
        'name' => __( 'Post Type' ),
        'singular_name' => __( 'Post Type' ),
      ),
      'public' => true,
      'has_archive' => true,
	  'taxonomies'  => array( 'cat-post' ),
	  'menu_icon'           => 'dashicons-format-aside',
	  'supports' => array( 'title')
    )
  );
}

add_action( 'init', 'create_post_type' );

function create_post_tax() {
register_taxonomy('cat-post', 'type',array("hierarchical" => true,"label" => "Κατηγορία Post","singular_label" => "Κατηγορίες",'update_count_callback' => '_update_post_term_count','query_var' => true,'rewrite' => array( 'slug' => 'cat-post', 'with_front' => false ),'public' => true,'show_ui' => true,'show_tagcloud' => true,'_builtin' => false,'show_in_nav_menus' => false));
}

add_action( 'init', 'create_post_tax' );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_plugin_name() {

	$plugin = new Plugin_Name();
	$plugin->run();
}
run_plugin_name();
function init_custom_post_types() {
	$args = array(
        'post_type' => 'type',
		'posts_per_page' => -1,
    );
    $the_query = new WP_Query($args);
    if ( $the_query->have_posts() ) {
		 while ( $the_query->have_posts() ) {
		    $the_query->the_post();
	  $title = get_the_title();
	  
	  $plugin2 = new GY_Post();
	  $plugin2->create_me($title);
		 }
	}
     
}
add_action('init', 'init_custom_post_types');

function print_custom_post_type($argt){
	
	$mode = $argt['mode'];
    
	$html="";
	
	if($mode=='grid'){

		if(isset($argt['type'])){
			$type = $argt['type'];
		}else{
			$type = -1;
		}

		if(isset($argt['tax'])){
			$tax = $argt['tax'];
		}else{
			$tax = -1;
		}

		if(isset($argt['field'])){
			$field = $argt['field'];
		}else{
			$field = 'slug';
		}

		if(isset($argt['field-value'])){
			$field_value = $argt['field-value'];
		}else{
			$field_value = 'all';
		}

		if(isset($argt['order'])){
			$order = $argt['order'];
		}else{
			$order = 'DESC';
		}

		if(isset($argt['orderby'])){
			$orderby = $argt['orderby'];
		}else{
			$orderby = 'date';
		}

		if(isset($argt['limit'])){
			$limit = $argt['limit'];
		}else{
			$limit = -1;
		}

		if(isset($argt['columns'])){
			$columns = $argt['columns'];
		}else{
			$columns = 3;
		}

		if(isset($argt['pagination'])){
			$pagination = $argt['pagination'];
		}else{
			$pagination = 0;
		}

		if(isset($argt['scontent'])){
			$content = $argt['scontent'];
		}else{
			$content = 0;
		}

		if(isset($argt['sexcerpt'])){
			$excerpt = $argt['sexcerpt'];
		}else{
			$excerpt = 0;
		}

		if(isset($argt['sdate'])){
			$date = $argt['sdate'];
		}else{
			$date = 0;
		}

		if(isset($argt['stitle'])){
			$title = $argt['stitle'];
		}else{
			$title = 0;
		}

		if(isset($argt['image'])){
			$image = $argt['image'];
		}else{
			$image = 0;
		}
		
		if(isset($argt['btntext'])){
			$btntext = $argt['btntext'];
		}else{
			$btntext = 0;
		}


		$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
		if($type!=-1){
			if($tax!=-1){
				query_posts(  array ( 
					'posts_per_page' => $limit, 
					'post_type' => $type, 
					'order' => $order, 
					'orderby' => $orderby, 
					'paged' => $paged,
					'tax_query' => array(
							array (
								'taxonomy' => $tax,
								'field' => $field,
								'terms' => $field_value,
							)
						),
				) );

			}else{
				query_posts(  array ( 
					'posts_per_page' => $limit, 
					'post_type' => $type, 
					'order' => $order, 
					'orderby' => $orderby, 
					'paged' => $paged,
				) );
			}

			global $wp_query;

			$html='';
			$html .= '<div class="'.$type.'-container column one">';
			if(have_posts() ){
				$total_pages = $wp_query->max_num_pages;
				$current_page = max(1, get_query_var('paged'));

				switch ($columns) {
					case 1:
						$columns = 'one';
						break;
					case 2:
						$columns = 'one-second';
						break;
					case 3:
						$columns = 'one-third';
						break;
					case 4:
						$columns = 'one-fourth';
						break;
					case 5:
						$columns = 'one-fifth';
						break;
					default:
						$columns = 'one-third';
						break;
				}

				while ( have_posts() ){

					the_post();
					if ($type == 'videos') {
					    $link =get_field('video_link');
					}else {
					    $link =get_permalink();
					}

					if($image==='left'){
        				$style='width:50%;float:left;';
        			}else if($image==='top'){
        				$style='width:100%;float:initial;';
        			}else if(!$image){
        				$style=0;
        			}else{
        			    $style="";
        			}

					$html .= '<div class="'.$type.'-wrapper column '.$columns.'"><div class="inner-column">';
					
					$html .= '<div class="'.$type.'-image post-type-image" style="'.$style.'"><a href="'.$link.'">
									<div class="image-wrapper">
										<img src="'.get_the_post_thumbnail_url(get_the_ID(),'full').'" alt="">
									</div>
								</a></div>';
					$html .= '<div class="'.$type.'-details-wrapper post-type-details-wrapper" style="'.$style.'"><div class="inner-wrapper">';
					if($date){
						$html .= '<div class="'.$type.'-date post-type-date">'.get_the_date().'</div>';
					}
					if($title){
					    if ($type != 'testimonials') {
					        $html .= '<div class="'.$type.'-title post-type-title"><a href="'.$link.'"><h2>'.get_the_title().'</h2></a></div>';
					    }
						
					}
					if ($type == 'team') {
					    $html .= '<div class="profession">'.get_field('profession').'</div>';
					}
					if($content){
						$html .=  '<div class="'.$type.'-excerpt post-type-excerpt"><p>'.get_the_content().'</p></div>';
					}
					if($excerpt){
						$html .=  '<div class="'.$type.'-excerpt post-type-excerpt"><p>'.get_the_excerpt().'</p></div>';
					}
					if($btntext){
						$html .='<a class="more-btn" href="'.$link.'">'.$btntext.'</a>';
					}
					if($title){
					    if ($type == 'testimonials') {
					        $html .= '<div class="'.$type.'-title post-type-title"><a href="'.$link.'"><h2>'.get_the_title().'</h2></a></div>';
					    }
						
					}
					$html .='</div></div></div></div>';

				}

				$html .= '</div>';
				
				if($pagination){
					$html .= '<div class="'.$type.'-pagination-wrapper post-type-pagination-wrapper">';
					$html .= paginate_links(array(
								'base' => get_pagenum_link(1) . '%_%',
								'format' => 'page/%#%',
								'current' => $current_page,
								'total' => $total_pages,
							));
					$html .= '</div>';
				}
			}
		}else if($type==-1){
			if($tax){
				$terms = get_terms( array(
					'taxonomy' => $tax,
					'exclude'=>1,
					'hide_empty' => false,
				) );
			}
			
			switch ($columns) {
					case 1:
						$columns = 'one';
						break;
					case 2:
						$columns = 'one-second';
						break;
					case 3:
						$columns = 'one-third';
						break;
					case 4:
						$columns = 'one-fourth';
						break;
					case 5:
						$columns = 'one-fifth';
						break;
					default:
						$columns = 'one-third';
						break;
			}
			
			if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
				
				if($image=='left'){
					$style='width:50%;float:left;';
				}else if($image=='top'){
					$style='width:100%;float:initial;';
				}else{
					$style='';
				}
				
				foreach( $terms as $category ) {
					$link =get_term_link($category->name,$tax);
					$color = get_field('taged_color',$category);
					$thumbnail = get_field('thumbnail',$category);
					
					$html .= '<div class="'.$tax.'-wrapper column '.$columns.'"><div class="inner-column">
								<div class="'.$type.'-image tax-image" style="'.$style.'"><a href="'.$link.'">
									<div class="image-wrapper">
										<img src="'.$thumbnail['url'].'" alt="">
									</div>
								</a></div>';
					$html .= '<div class="'.$tax.'-details-wrapper tax-details-wrapper" style="'.$style.'">';
					
					if($title){
						$html .= '<div class="'.$tax.'-title tax-title"><a href="'.$link.'"><h2>'.esc_attr($category->name).'</h2></a></div>';
					}
					if($excerpt){
						$html .=  '<div class="'.$tax.'-excerpt tax-excerpt"><p>'.esc_attr($category->description).'</p></div>';
					}
					if($btntext){
						$html .='<a class="more-btn" href="'.$link.'">'.$btntext.'</a>';
					}
					$html .='</div></div></div>';
				}
			}
		}
	}else if($mode=='slider'){
		$type = $argt['type'];
		$tax = $argt['tax'];
		$field = $argt['field'];
		$field_value = $argt['field-value'];

		if(isset($argt['order'])){
			$order = $argt['order'];
		}else{
			$order = 'DESC';
		}

		if(isset($argt['slidesperview'])){
			$slidesPerView = $argt['slidesperview'];
		}else{
			$slidesPerView = 3;
		}

		if(isset($argt['centered'])){
			$centered = $argt['centered'];
		}else{
			$centered = 0;
		}

		if(isset($argt['pagination'])){
			$pagination = $argt['pagination'];
		}else{
			$pagination = 0;
		}

		if(isset($argt['sexcerpt'])){
			$excerpt = $argt['sexcerpt'];
		}else{
			$excerpt = 0;
		}
		
		if(isset($argt['scontent'])){
			$content = $argt['scontent'];
		}else{
			$content = 0;
		}
		
		if(isset($argt['sauthor'])){
			$sauthor = $argt['sauthor'];
		}else{
			$sauthor = 0;
		}

		if(isset($argt['sdate'])){
			$date = $argt['sdate'];
		}else{
			$date = 0;
		}

		if(isset($argt['stitle'])){
			$title = $argt['stitle'];
		}else{
			$title = 1;
		}

		if(isset($argt['image'])){
			$image = $argt['image'];
		}else{
			$image = 'top';
		}

		if(isset($argt['arrows'])){
			$arrows = $argt['arrows'];
		}else{
			$arrows = 0;
		}

		if(isset($argt['autoplay'])){
			$autoplay = $argt['autoplay'];
		}else{
			$autoplay = 0;
		}

		if(isset($argt['progressbar'])){
			$progressbar = $argt['progressbar'];
		}else{
			$progressbar = 0;
		}

		if(isset($argt['loop'])){
			$loop = $argt['loop'];
		}else{
			$loop = 0;
		}

		if(isset($argt['gap'])){
			$gap = $argt['gap'];
		}else{
			$gap = 30;
		}

		if(isset($argt['speed'])){
			$speed = $argt['speed'];
		}else{
			$speed = 0;
		}
		
		if(isset($argt['btntext'])){
			$btntext = $argt['btntext'];
		}else{
			$btntext = 0;
		}
		

		if($tax!=-1){
			query_posts(  array ( 
				'posts_per_page' => '-1', 
				'post_type' => $type, 
				'order' => $order, 
				'tax_query' => array(
						array (
							'taxonomy' => $tax,
							'field' => $field,
							'terms' => $field_value,
						)
					),
			) );
		}else{
			query_posts(  array ( 
				'posts_per_page' => '-1', 
				'post_type' => $type, 
				'order' => $order, 
			) );
		}

		$html.='<div class="swiper-container '.$type.'-container">
				<div class="swiper-wrapper '.$type.'-wrapper">';
		
		while ( have_posts() ){
		
			the_post();
			$link = get_permalink();

			if($image=='left'){
				$style='width:50%;float:left;';
			}else if($image=='top'){
				$style='width:100%;float:initial;';
			}else if(!$image){
				$style=0;
			}else{
			    $style="";
			}
			
			$html.='<div class="swiper-slide '.$type.'-slide">
						<div class="inner-column">';
						if($style!=0){
							$html.='<div class="'.$type.'-image post-type-image" style='.$style.'>
							<a href="'.$link.'">
								<div class="image-wrapper">
									<img src="'.get_the_post_thumbnail_url(get_the_ID(),'full').'" alt="">
								</div>
							</a>
							</div>';
						}
							$html.='<div class="'.$type.'-details-wrapper post-type-details-wrapper">';
							if($date){
								$html .= '<div class="'.$type.'-date post-type-date">'.get_the_date().'</div>';
							}
							if($title){
								$html .= '<div class="'.$type.'-title post-type-title"><a href="'.$link.'"><h2>'.get_the_title().'</h2></a></div>';
							}
							if($excerpt){
								$html .=  '<div class="'.$type.'-excerpt post-type-excerpt"><p>'.get_the_excerpt().'</p></div>';
							}
							if($content){
								$html .=  '<div class="'.$type.'-excerpt post-type-excerpt"><p>'.get_the_content().'</p></div>';
							}
							if($sauthor){
								$html .=  '<div class="author-details"><p><b>'.get_post_meta(get_the_ID(),'mfn-post-author',true).'</b></p></div>';
							}
							if($btntext){
								$html .='<a class="more-btn" href="'.$link.'">'.$btntext.'</a>';
							}
							
						$html .='</div>';
					$html .='</div>';
				$html .='</div>';

		}
		
		$html.='</div>';
		if($arrows){
			$html.='<!-- Add Arrows -->
				<div class="swiper-button-next"></div>
				<div class="swiper-button-prev"></div>';
		}
		if($pagination){
			$html.='<div class="swiper-pagination"></div>';
		};
	    $html.='</div>';

		$html .='<script type="text/javascript">
					jQuery(document).ready(function($){
						var swiper = new Swiper(".'.$type.'-container",{';
							if($slidesPerView){
								$html .='slidesPerView: '.$slidesPerView.',
										 spaceBetween: '.$gap.',';
							}
							if($autoplay){
								$html .='autoplay: {
											delay: '.$speed.',
											disableOnInteraction: false,
										},';
							}
							if($loop){
								$html .='loop: true,';
							}
							if($centered){
								$html .='centeredSlides: true,';
							}
							if($arrows){
								$html .='navigation: {
										nextEl: ".'.$type.'-container .swiper-button-next",
										prevEl: ".'.$type.'-container .swiper-button-prev",
										},';
							}
							if($pagination){
								$html .='pagination: {
											el: ".'.$type.'-container .swiper-pagination",
										},';
							}
							if($progressbar){
								$html .='pagination: {
											el: ".'.$type.'-container .swiper-pagination",
											type: ".'.$type.'-container .progressbar",
										},';
							}
							
							
						$html .='});
					});
				</script>';
		
	}
        
	wp_reset_query();
	return $html;
}

add_shortcode('print','print_custom_post_type');

function cpt_save_postdata() {
    global $post;
    if ($_POST['cpt-hidd'] == 'true') {
        $cp_public = get_post_meta($post->ID, 'cp_public', true);
        $cp_publicly_queryable = get_post_meta($post->ID, 'cp_publicly_queryable', true);
        $cp_show_ui = get_post_meta($post->ID, 'cp_show_ui', true);
        $cp_show_in_menu = get_post_meta($post->ID, 'cp_show_in_menu', true); 
        $cp_query_var = get_post_meta($post->ID, 'cp_query_var', true); 
        $cp_rewrite = get_post_meta($post->ID, 'cp_rewrite', true); 
        $cp_has_archive = get_post_meta($post->ID, 'cp_has_archive', true); 
        $cp_hierarchical = get_post_meta($post->ID, 'cp_hierarchical', true);
        $cp_capability_type = get_post_meta($post->ID, 'cp_capability_type', true);
        $cp_menu_position = get_post_meta($post->ID, 'cp_menu_position', true);
        $cp_s_title = get_post_meta($post->ID, 'cp_s_title', true);
        $cp_s_editor = get_post_meta($post->ID, 'cp_s_editor', true);
        $cp_s_author = get_post_meta($post->ID, 'cp_s_author', true);
        $cp_s_thumbnail = get_post_meta($post->ID, 'cp_s_thumbnail', true);
        $cp_s_excerpt = get_post_meta($post->ID, 'cp_s_excerpt', true);
        $cp_s_comments = get_post_meta($post->ID, 'cp_s_comments', true);
        $cp_general_name = get_post_meta($post->ID, 'cp_general_name', true);
        $cp_singular_name = get_post_meta($post->ID, 'cp_singular_name', true);
        $cp_add_new = get_post_meta($post->ID, 'cp_add_new', true);
        $cp_add_new_item = get_post_meta($post->ID, 'cp_add_new_item', true);
        $cp_edit_item = get_post_meta($post->ID, 'cp_edit_item', true);
        $cp_new_item = get_post_meta($post->ID, 'cp_new_item', true);
        $cp_all_items = get_post_meta($post->ID, 'cp_all_items', true);
        $cp_view_item = get_post_meta($post->ID, 'cp_view_item', true);
        $cp_search_items = get_post_meta($post->ID, 'cp_search_items', true);
        $cp_not_found = get_post_meta($post->ID, 'cp_not_found', true);
        $cp_not_found_in_trash = get_post_meta($post->ID, 'cp_not_found_in_trash', true);
        $cp_parent_item_colon = get_post_meta($post->ID, 'cp_parent_item_colon', true);

        update_post_meta($post->ID, 'cp_public', $_POST['cp_public'], $cp_public);
        update_post_meta($post->ID, 'cp_publicly_queryable', $_POST['cp_publicly_queryable'], $cp_publicly_queryable);
        update_post_meta($post->ID, 'cp_show_ui', $_POST['cp_show_ui'], $cp_show_ui);
        update_post_meta($post->ID, 'cp_show_in_menu', $_POST['cp_show_in_menu'], $cp_show_in_menu);
        update_post_meta($post->ID, 'cp_query_var', $_POST['cp_query_var'], $cp_query_var);
        update_post_meta($post->ID, 'cp_rewrite', $_POST['cp_rewrite'], $cp_rewrite);
        update_post_meta($post->ID, 'cp_has_archive', $_POST['cp_has_archive'], $cp_has_archive);
        update_post_meta($post->ID, 'cp_hierarchical', $_POST['cp_hierarchical'], $cp_hierarchical);
        update_post_meta($post->ID, 'cp_capability_type', $_POST['cp_capability_type'], $cp_capability_type);
        update_post_meta($post->ID, 'cp_menu_position', $_POST['cp_menu_position'], $cp_menu_position);
        update_post_meta($post->ID, 'cp_s_title', $_POST['cp_s_title'], $cp_s_title);
        update_post_meta($post->ID, 'cp_s_editor', $_POST['cp_s_editor'], $cp_s_editor);
        update_post_meta($post->ID, 'cp_s_author', $_POST['cp_s_author'], $cp_s_author);
        update_post_meta($post->ID, 'cp_s_thumbnail', $_POST['cp_s_thumbnail'], $cp_s_thumbnail);
        update_post_meta($post->ID, 'cp_s_excerpt', $_POST['cp_s_excerpt'], $cp_s_excerpt);
        update_post_meta($post->ID, 'cp_s_comments', $_POST['cp_s_comments'], $cp_s_comments);
        update_post_meta($post->ID, 'cp_general_name', $_POST['cp_general_name'], $cp_general_name);
        update_post_meta($post->ID, 'cp_singular_name', $_POST['cp_singular_name'], $cp_singular_name);
        update_post_meta($post->ID, 'cp_add_new', $_POST['cp_add_new'], $cp_add_new);
        update_post_meta($post->ID, 'cp_add_new_item', $_POST['cp_add_new_item'], $cp_add_new_item);
        update_post_meta($post->ID, 'cp_edit_item', $_POST['cp_edit_item'], $cp_edit_item);
        update_post_meta($post->ID, 'cp_new_item', $_POST['cp_new_item'], $cp_new_item);
        update_post_meta($post->ID, 'cp_all_items', $_POST['cp_all_items'], $cp_all_items);
        update_post_meta($post->ID, 'cp_view_item', $_POST['cp_view_item'], $cp_view_item);
        update_post_meta($post->ID, 'cp_search_items', $_POST['cp_search_items'], $cp_search_items);
        update_post_meta($post->ID, 'cp_not_found', $_POST['cp_not_found'], $cp_not_found);
        update_post_meta($post->ID, 'cp_not_found_in_trash', $_POST['cp_not_found_in_trash'], $cp_not_found_in_trash);
        update_post_meta($post->ID, 'cp_parent_item_colon', $_POST['cp_parent_item_colon'], $cp_parent_item_colon);
    }
}

function cpt_inner_custom_box() {
    global $post;

    $cp_public = get_post_meta($post->ID, 'cp_public', true);
    $cp_publicly_queryable = get_post_meta($post->ID, 'cp_publicly_queryable', true);
    $cp_show_ui = get_post_meta($post->ID, 'cp_show_ui', true);
    $cp_show_in_menu = get_post_meta($post->ID, 'cp_show_in_menu', true); 
    $cp_query_var = get_post_meta($post->ID, 'cp_query_var', true); 
    $cp_rewrite = get_post_meta($post->ID, 'cp_rewrite', true); 
    $cp_has_archive = get_post_meta($post->ID, 'cp_has_archive', true); 
    $cp_hierarchical = get_post_meta($post->ID, 'cp_hierarchical', true);
    $cp_capability_type = get_post_meta($post->ID, 'cp_capability_type', true);
    $cp_menu_position = get_post_meta($post->ID, 'cp_menu_position', true);
    $cp_s_title = get_post_meta($post->ID, 'cp_s_title', true);
    $cp_s_editor = get_post_meta($post->ID, 'cp_s_editor', true);
    $cp_s_author = get_post_meta($post->ID, 'cp_s_author', true);
    $cp_s_thumbnail = get_post_meta($post->ID, 'cp_s_thumbnail', true);
    $cp_s_excerpt = get_post_meta($post->ID, 'cp_s_excerpt', true);
    $cp_s_comments = get_post_meta($post->ID, 'cp_s_comments', true);
    $cp_general_name = get_post_meta($post->ID, 'cp_general_name', true);
    $cp_singular_name = get_post_meta($post->ID, 'cp_singular_name', true);
    $cp_add_new = get_post_meta($post->ID, 'cp_add_new', true);
    $cp_add_new_item = get_post_meta($post->ID, 'cp_add_new_item', true);
    $cp_edit_item = get_post_meta($post->ID, 'cp_edit_item', true);
    $cp_new_item = get_post_meta($post->ID, 'cp_new_item', true);
    $cp_all_items = get_post_meta($post->ID, 'cp_all_items', true);
    $cp_view_item = get_post_meta($post->ID, 'cp_view_item', true);
    $cp_search_items = get_post_meta($post->ID, 'cp_search_items', true);
    $cp_not_found = get_post_meta($post->ID, 'cp_not_found', true);
    $cp_not_found_in_trash = get_post_meta($post->ID, 'cp_not_found_in_trash', true);
    $cp_parent_item_colon = get_post_meta($post->ID, 'cp_parent_item_colon', true);
    ?>
    <h4>Main Settings:</h4>
    <table width="100%">
        <tr>
            <td><input type="checkbox" <?php
    if ($cp_public == "on") {
        echo "checked";
    }
    ?> name="cp_public" /> Public </td>
            <td><input type="checkbox" <?php
                   if ($cp_publicly_queryable == "on") {
                       echo "checked";
                   }
    ?> name="cp_publicly_queryable" /> Publicly Queryable </td>
            <td><input type="checkbox" <?php
                   if ($cp_show_ui == "on") {
                       echo "checked";
                   }
    ?> name="cp_show_ui" /> Show UI </td>
            <td><input type="checkbox" <?php
                   if ($cp_show_in_menu == "on") {
                       echo "checked";
                   }
    ?> name="cp_show_in_menu" /> Show in Menu </td>
            <td><input type="checkbox" <?php
                   if ($cp_query_var == "on") {
                       echo "checked";
                   }
    ?> name="cp_query_var" /> Query Var </td>
            <td><input type="checkbox" <?php
                   if ($cp_rewrite == "on") {
                       echo "checked";
                   }
    ?> name="cp_rewrite" /> Rewrite </td>
            <td><input type="checkbox" <?php
                   if ($cp_has_archive == "on") {
                       echo "checked";
                   }
    ?> name="cp_has_archive" /> Has Archive </td>
            <td><input type="checkbox" <?php
                   if ($cp_hierarchical == "on") {
                       echo "checked";
                   }
    ?> name="cp_hierarchical" /> Hierarchical </td>
        </tr>
    </table>
    <br/>
    <table>
        <tr>
            <td>Capability Type:<br/><select name="cp_capability_type">
                    <option value="5" <?php
                   if ($cp_capability_type == "5") {
                       echo "selected";
                   }
    ?>>below Posts</option>
                    <option value="10" <?php
                        if ($cp_capability_type == "10") {
                            echo "selected";
                        }
    ?>>below Media</option>
                    <option value="15" <?php
                        if ($cp_capability_type == "15") {
                            echo "selected";
                        }
    ?>>below Links</option>
                    <option value="20" <?php
                        if ($cp_capability_type == "20") {
                            echo "selected";
                        }
    ?>>below Pages</option>
                    <option value="25" <?php
                        if ($cp_capability_type == "25") {
                            echo "selected";
                        }
    ?>>below comments</option>
                    <option value="60" <?php
                        if ($cp_capability_type == "60") {
                            echo "selected";
                        }
    ?>>below first separator</option>
                    <option value="65" <?php
                        if ($cp_capability_type == "65") {
                            echo "selected";
                        }
    ?>>below Plugins</option>
                    <option value="70" <?php
                        if ($cp_capability_type == "70") {
                            echo "selected";
                        }
    ?>>below Users</option>
                    <option value="75" <?php
                        if ($cp_capability_type == "75") {
                            echo "selected";
                        }
    ?>>below Tools</option>
                    <option value="80" <?php
                        if ($cp_capability_type == "80") {
                            echo "selected";
                        }
    ?>>below Settings</option>
                    <option value="100" <?php
                        if ($cp_capability_type == "100") {
                            echo "selected";
                        }
    ?>>below second separator</option>

                </select></td>
            <td>Menu Position:<br/><select name="cp_menu_position">
                    <option value="post" <?php
                        if ($cp_menu_position == "post") {
                            echo "selected";
                        }
    ?>>Post</option>
                    <option value="page" <?php
                        if ($cp_menu_position == "page") {
                            echo "selected";
                        }
    ?>>Page</option>
                </select></td>
        </tr>
    </table>
    <h4>Supports:</h4>
    <table width="100%">
        <tr>
            <td><input type="checkbox" name="cp_s_title" <?php
                        if ($cp_s_title == "on") {
                            echo "checked";
                        }
    ?>/> Title </td>
            <td><input type="checkbox" name="cp_s_editor" <?php
                   if ($cp_s_editor == "on") {
                       echo "checked";
                   }
    ?>/> Editor  </td>
            <td><input type="checkbox" name="cp_s_author" <?php
                   if ($cp_s_author == "on") {
                       echo "checked";
                   }
    ?>/> Author </td> 
            <td><input type="checkbox" name="cp_s_thumbnail" <?php
                   if ($cp_s_thumbnail == "on") {
                       echo "checked";
                   }
    ?>/> Thumbnail  </td>
            <td><input type="checkbox" name="cp_s_excerpt" <?php
                   if ($cp_s_excerpt == "on") {
                       echo "checked";
                   }
    ?>/> Excerpt  </td>
            <td><input type="checkbox" name="cp_s_comments" <?php
                   if ($cp_s_comments == "on") {
                       echo "checked";
                   }
    ?>/> Comments  </td>
        </tr>
    </table>
    <h4>Lables:</h4>
    <table width="100%">
        <tr>
            <td>General name:<br/> <input type="text" name="cp_general_name" value="<?php echo $cp_general_name; ?>"/></td>
            <td>Singular name:<br/> <input type="text" name="cp_singular_name" value="<?php echo $cp_singular_name; ?>"/></td>
            <td>Add new:<br/> <input type="text" name="cp_add_new" value="<?php echo $cp_add_new; ?>"/></td>
        </tr>
        <tr>
            <td>Add new item:<br/> <input type="text" name="cp_add_new_item" value="<?php echo $cp_add_new_item; ?>"/></td>
            <td>Edit Item:<br/> <input type="text" name="cp_edit_item" value="<?php echo $cp_edit_item; ?>"/></td>
            <td>New Item:<br/> <input type="text" name="cp_new_item" value="<?php echo $cp_new_item; ?>"/></td>
        </tr>
        <tr>
            <td>All Items:<br/> <input type="text" name="cp_all_items" value="<?php echo $cp_all_items; ?>"/></td>
            <td>View Item:<br/> <input type="text" name="cp_view_item" value="<?php echo $cp_view_item; ?>"/></td>
            <td>Search Items:<br/> <input type="text" name="cp_search_items" value="<?php echo $cp_search_items; ?>"/></td>
        </tr>
        <tr>
            <td>Not Found:<br/> <input type="text" name="cp_not_found" value="<?php echo $cp_not_found; ?>"/></td>
            <td>Not Found in Trash:<br/> <input type="text" name="cp_not_found_in_trash" value="<?php echo $cp_not_found_in_trash; ?>"/></td>
            <td>Parent item Column:<br/> <input type="text" name="cp_parent_item_colon" value="<?php echo $cp_parent_item_colon; ?>"/></td>
        </tr>
    </table>
    <input type="hidden" name="cpt-hidd" value="true" />
    <?php
}



function cpt_add_meta_boxes() {
    add_meta_box('cpt_meta_id', 'Custom Post Type Settings', 'cpt_inner_custom_box', 'type', 'normal');
}

add_action('save_post', 'cpt_save_postdata');
add_action('add_meta_boxes', 'cpt_add_meta_boxes');

function shortcode_save_postdata() {
    global $post;
    if ($_POST['gm_pt-hidd'] == 'true') {
        $pt_mode = get_post_meta($post->ID, 'pt_mode', true);
        $pt_type = get_post_meta($post->ID, 'gm_pt_type', true);
        $pt_orderby = get_post_meta($post->ID, 'gm_pt_orderby', true);
        $pt_order = get_post_meta($post->ID, 'gm_pt_order', true);
        $pt_col = get_post_meta($post->ID, 'gm_pt_col', true); 
        $pt_limit = get_post_meta($post->ID, 'gm_pt_limit', true); 
        $pt_tax = get_post_meta($post->ID, 'gm_pt_tax', true); 
        $pt_field = get_post_meta($post->ID, 'gm_pt_field', true);
        $pt_value = get_post_meta($post->ID, 'gm_pt_value', true);
        $pt_s_pagination = get_post_meta($post->ID, 'gm_pt_s_pagination', true);
        $pt_s_title = get_post_meta($post->ID, 'gm_pt_s_title', true);
        $pt_s_date = get_post_meta($post->ID, 'gm_pt_s_date', true);
        $pt_s_excerpt = get_post_meta($post->ID, 'gm_pt_s_excerpt', true);
        $pt_s_thumbnail = get_post_meta($post->ID, 'gm_pt_s_thumbnail', true);
        $pt_s_more = get_post_meta($post->ID, 'gm_pt_s_more', true);
        $pt_s_arrows = 0;
        $pt_s_autoplay = 0;
        $pt_s_progressbar = 0;
        $pt_s_speed = 0;
        $pt_s_slides = 0;
        $pt_s_gap = 0;
        $pt_s_loop = 0;
        update_post_meta($post->ID, 'pt_mode', $_POST['pt_mode'], $pt_mode);
        update_post_meta($post->ID, 'gm_pt_type', $_POST['gm_pt_type'], $pt_type);
        update_post_meta($post->ID, 'gm_pt_orderby', $_POST['gm_pt_orderby'], $pt_orderby);
        update_post_meta($post->ID, 'gm_pt_order', $_POST['gm_pt_order'], $pt_order);
        update_post_meta($post->ID, 'gm_pt_col', $_POST['gm_pt_col'], $pt_col);
        update_post_meta($post->ID, 'gm_pt_limit', $_POST['gm_pt_limit'], $pt_limit);
        update_post_meta($post->ID, 'gm_pt_tax', $_POST['gm_pt_tax'], $pt_tax);
        update_post_meta($post->ID, 'gm_pt_field', $_POST['gm_pt_field'], $pt_field);
        update_post_meta($post->ID, 'gm_pt_value', $_POST['gm_pt_value'], $pt_value);
        update_post_meta($post->ID, 'gm_pt_s_pagination', $_POST['gm_pt_s_pagination'], $pt_s_pagination);
        update_post_meta($post->ID, 'gm_pt_s_title', $_POST['gm_pt_s_title'], $pt_s_title);
        update_post_meta($post->ID, 'gm_pt_s_date', $_POST['gm_pt_s_date'], $pt_s_date);
        update_post_meta($post->ID, 'gm_pt_s_excerpt', $_POST['gm_pt_s_excerpt'], $pt_s_excerpt);
        update_post_meta($post->ID, 'gm_pt_s_thumbnail', $_POST['gm_pt_s_thumbnail'], $pt_s_thumbnail);
        update_post_meta($post->ID, 'gm_pt_s_more', $_POST['gm_pt_s_more'], $pt_s_more);
        update_post_meta($post->ID, 'sm_pt_s_arrows', $_POST['gm_pt_s_arrows'], $pt_s_arrows);
        update_post_meta($post->ID, 'sm_pt_s_autoplay', $_POST['gm_pt_s_autoplay'], $pt_s_autoplay);
        update_post_meta($post->ID, 'sm_pt_s_progressbar', $_POST['gm_pt_s_progressbar'], $pt_s_progressbar);
        update_post_meta($post->ID, 'sm_pt_s_speed', $_POST['gm_pt_s_speed'], $pt_s_speed);
        update_post_meta($post->ID, 'sm_pt_s_slides', $_POST['gm_pt_s_slides'], $pt_s_slides);
        update_post_meta($post->ID, 'sm_pt_s_gap', $_POST['gm_pt_s_gap'], $pt_s_gap);
        update_post_meta($post->ID, 'sm_pt_s_loop', $_POST['gm_pt_s_loop'], $pt_s_loop);
    }else if($_POST['sm_pt-hidd'] == 'true'){
        $pt_mode = get_post_meta($post->ID, 'pt_mode', true);
        $pt_type = get_post_meta($post->ID, 'sm_pt_type', true);
        $pt_orderby = get_post_meta($post->ID, 'sm_pt_orderby', true);
        $pt_order = get_post_meta($post->ID, 'sm_pt_order', true);
        $pt_col = 0;
        $pt_limit = 0;
        $pt_tax = get_post_meta($post->ID, 'sm_pt_tax', true); 
        $pt_field = get_post_meta($post->ID, 'sm_pt_field', true);
        $pt_value = get_post_meta($post->ID, 'sm_pt_value', true);
        $pt_s_pagination = get_post_meta($post->ID, 'sm_pt_s_pagination', true);
        $pt_s_title = get_post_meta($post->ID, 'sm_pt_s_title', true);
        $pt_s_date = get_post_meta($post->ID, 'sm_pt_s_date', true);
        $pt_s_excerpt = get_post_meta($post->ID, 'sm_pt_s_excerpt', true);
        $pt_s_thumbnail = get_post_meta($post->ID, 'sm_pt_s_thumbnail', true);
        $pt_s_more = get_post_meta($post->ID, 'sm_pt_s_more', true);
        $pt_s_arrows = get_post_meta($post->ID, 'sm_pt_s_arrows', true);
        $pt_s_autoplay = get_post_meta($post->ID, 'sm_pt_s_autoplay', true);
        $pt_s_progressbar = get_post_meta($post->ID, 'sm_pt_s_progressbar', true);
        $pt_s_speed = get_post_meta($post->ID, 'sm_pt_s_speed', true);
        $pt_s_slides = get_post_meta($post->ID, 'sm_pt_s_slides', true);
        $pt_s_gap = get_post_meta($post->ID, 'sm_pt_s_gap', true);
        $pt_s_loop = get_post_meta($post->ID, 'sm_pt_s_loop', true);
        update_post_meta($post->ID, 'pt_mode', $_POST['pt_mode'], $pt_mode);
        update_post_meta($post->ID, 'sm_pt_type', $_POST['sm_pt_type'], $pt_type);
        update_post_meta($post->ID, 'sm_pt_orderby', $_POST['sm_pt_orderby'], $pt_orderby);
        update_post_meta($post->ID, 'sm_pt_order', $_POST['sm_pt_order'], $pt_order);
        update_post_meta($post->ID, 'gm_pt_col', $_POST['gm_pt_col'], $pt_col);
        update_post_meta($post->ID, 'gm_pt_limit', $_POST['gm_pt_limit'], $pt_limit);
        update_post_meta($post->ID, 'sm_pt_tax', $_POST['sm_pt_tax'], $pt_tax);
        update_post_meta($post->ID, 'sm_pt_field', $_POST['sm_pt_field'], $pt_field);
        update_post_meta($post->ID, 'sm_pt_value', $_POST['sm_pt_value'], $pt_value);
        update_post_meta($post->ID, 'sm_pt_s_pagination', $_POST['sm_pt_s_pagination'], $pt_s_pagination);
        update_post_meta($post->ID, 'sm_pt_s_title', $_POST['sm_pt_s_title'], $pt_s_title);
        update_post_meta($post->ID, 'sm_pt_s_date', $_POST['sm_pt_s_date'], $pt_s_date);
        update_post_meta($post->ID, 'sm_pt_s_excerpt', $_POST['sm_pt_s_excerpt'], $pt_s_excerpt);
        update_post_meta($post->ID, 'sm_pt_s_thumbnail', $_POST['sm_pt_s_thumbnail'], $pt_s_thumbnail);
        update_post_meta($post->ID, 'sm_pt_s_more', $_POST['sm_pt_s_more'], $pt_s_more);
        update_post_meta($post->ID, 'sm_pt_s_arrows', $_POST['sm_pt_s_arrows'], $pt_s_arrows);
        update_post_meta($post->ID, 'sm_pt_s_autoplay', $_POST['sm_pt_s_autoplay'], $pt_s_autoplay);
        update_post_meta($post->ID, 'sm_pt_s_progressbar', $_POST['sm_pt_s_progressbar'], $pt_s_progressbar);
        update_post_meta($post->ID, 'sm_pt_s_speed', $_POST['sm_pt_s_speed'], $pt_s_speed);
        update_post_meta($post->ID, 'sm_pt_s_slides', $_POST['sm_pt_s_slides'], $pt_s_slides);
        update_post_meta($post->ID, 'sm_pt_s_gap', $_POST['sm_pt_s_gap'], $pt_s_gap);
        update_post_meta($post->ID, 'sm_pt_s_loop', $_POST['sm_pt_s_loop'], $pt_s_loop);
    }
    
	$short = '';
	$short .= '[print ';
	if ($pt_mode == "Grid") {
		
		$pt_mode = "grid";
	    $short .= 'mode="'.$pt_mode.'" ';
	    
	    if ($pt_col) {
		    $short .='columns="'.$pt_col.'" ';
		}
		if ($pt_limit) {
		    $short .='limit="'.$pt_limit.'" ';
		}
		
	}else if($pt_mode == "Slider"){
	    
	    $pt_mode = "slider";
	    $short .= 'mode="'.$pt_mode.'" ';
	    
	    if ($pt_s_arrows) {
		    $short .='arrows="1"';  	
		}
		if ($pt_s_autoplay) {
		    $short .='autoplay="1"';  	
		}
		if ($pt_s_progressbar) {
		    $short .='progressbar="1"';  	
		}
		if ($pt_s_slides) {
		    $short .='slidesperview="'.$pt_s_slides.'"';  	
		}
		if ($pt_s_gap) {
		    $short .='gap="'.$pt_s_gap.'"';  	
		}
		if ($pt_s_loop) {
		    $short .='loop="1"';  	
		}
		if ($pt_s_speed) {
		    $short .='speed="'.$pt_s_speed.'"';  	
		}
		
	}
	if ($pt_type) {
	    $short .='type="'.$pt_type.'" ';
	}
	if ($pt_tax) {
	    $short .='tax="'.$pt_tax.'" ';
	}
	if ($pt_field) {
	    $short .='field="'.$pt_field.'" ';
	}
	if ($pt_value) {
	    $short .='field-value="'.$pt_value.'" ';
	}
	if ($pt_order) {
	    $short .='order="'.$pt_order.'" ';
	}
	if ($pt_orderby) {
	    $short .='orderby="'.$pt_orderby.'" ';
	}
		
	if ($pt_s_pagination) {
	    $short .='pagination="1" ';
	}
	if ($pt_s_thumbnail=='Top') {
	    $short .='image="top" ';
	}else if($pt_s_thumbnail=='Left'){
		$short .='image="left" ';
	}else{
		$short .='image="0" ';
	}
	if ($pt_s_date) {
	    $short .='sdate="1" ';
	}
	if ($pt_s_excerpt) {
	    $short .='sexcerpt="1" ';
	}
	if ($pt_s_title) {
	    $short .='stitle="1" ';
	}
	if ($pt_s_more) {
	    $short .='btntext="'.$pt_s_more.'"';  	
	}
		
		$short .= ']';
		
		update_post_meta($post->ID, 'pt_short', $short);
    }

function shortcode_details() {
    global $post;
    
    $pt_mode = get_post_meta($post->ID, 'pt_mode', true);
    if($pt_mode=='Grid'){
        $pt_type = get_post_meta($post->ID, 'gm_pt_type', true);
        $pt_orderby = get_post_meta($post->ID, 'gm_pt_orderby', true);
        $pt_order = get_post_meta($post->ID, 'gm_pt_order', true);
        $pt_col = get_post_meta($post->ID, 'gm_pt_col', true); 
        $pt_limit = get_post_meta($post->ID, 'gm_pt_limit', true); 
        $pt_tax = get_post_meta($post->ID, 'gm_pt_tax', true); 
        $pt_field = get_post_meta($post->ID, 'gm_pt_field', true);
        $pt_value = get_post_meta($post->ID, 'gm_pt_value', true);
        $pt_s_pagination = get_post_meta($post->ID, 'gm_pt_s_pagination', true);
        $pt_s_title = get_post_meta($post->ID, 'gm_pt_s_title', true);
        $pt_s_date = get_post_meta($post->ID, 'gm_pt_s_date', true);
        $pt_s_excerpt = get_post_meta($post->ID, 'gm_pt_s_excerpt', true);
        $pt_s_thumbnail = get_post_meta($post->ID, 'gm_pt_s_thumbnail', true);
        $pt_s_more = get_post_meta($post->ID, 'gm_pt_s_more', true);
    }else{
        $pt_type = get_post_meta($post->ID, 'sm_pt_type', true);
        $pt_orderby = get_post_meta($post->ID, 'sm_pt_orderby', true);
        $pt_order = get_post_meta($post->ID, 'sm_pt_order', true);
        $pt_col = "";
        $pt_limit = "";
        $pt_tax = get_post_meta($post->ID, 'sm_pt_tax', true); 
        $pt_field = get_post_meta($post->ID, 'sm_pt_field', true);
        $pt_value = get_post_meta($post->ID, 'sm_pt_value', true);
        $pt_s_pagination = get_post_meta($post->ID, 'sm_pt_s_pagination', true);
        $pt_s_title = get_post_meta($post->ID, 'sm_pt_s_title', true);
        $pt_s_date = get_post_meta($post->ID, 'sm_pt_s_date', true);
        $pt_s_excerpt = get_post_meta($post->ID, 'sm_pt_s_excerpt', true);
        $pt_s_thumbnail = get_post_meta($post->ID, 'sm_pt_s_thumbnail', true);
        $pt_s_arrows = get_post_meta($post->ID, 'sm_pt_s_arrows', true);
        $pt_s_autoplay = get_post_meta($post->ID, 'sm_pt_s_autoplay', true);
        $pt_s_progressbar = get_post_meta($post->ID, 'sm_pt_s_progressbar', true);
        $pt_s_loop = get_post_meta($post->ID, 'sm_pt_s_loop', true);
        $pt_s_speed = get_post_meta($post->ID, 'sm_pt_s_speed', true);
        $pt_s_slides = get_post_meta($post->ID, 'sm_pt_s_slides', true);
        $pt_s_gap = get_post_meta($post->ID, 'sm_pt_s_gap', true);
        $pt_s_more = get_post_meta($post->ID, 'sm_pt_s_more', true);
    }
    ?>

    
    <table>
    	<td style="display: table">Display mode: 
    		<select id="select-mode" name="pt_mode"/>
				<option value="Grid" <?php if($pt_mode=='Grid'){ echo 'selected'; }?>>Grid</option>
				<option value="Slider" <?php if($pt_mode=='Slider'){ echo 'selected'; }?>>Slider</option>
		</td>
    </table>

    <div id="grid-mode">
	    <div style="float:left;width: 50%">
		    <h4>Main Settings:</h4>
		    <table width="100%">
		        <tr><td><input type="text" placeholder="Post Type" name="gm_pt_type" value="<?php if($pt_type){ echo $pt_type; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Order by" name="gm_pt_orderby" value="<?php if($pt_orderby){ echo $pt_orderby; }?>"></td></tr>
				<tr><td><input type="text" placeholder="Order" name="gm_pt_order" value="<?php if($pt_order){ echo $pt_order; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Columns" name="gm_pt_col" value="<?php if($pt_col){ echo $pt_col; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Limit" name="gm_pt_limit" value="<?php if($pt_limit){ echo $pt_limit; }?>"></td></tr>
		    </table>
		</div>
	    
	    <div style="float:left;width: 50%">
		    <table width="100%">
		    	<h4>Taxonomy Query Settings:</h4>
		    	<p>(*Optionals... submited only for tax query)</p>
				<tr><td><input type="text" placeholder="Post Type Taxonomy" name="gm_pt_tax" value="<?php if($pt_tax){ echo $pt_tax; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Category Field" name="gm_pt_field" value="<?php if($pt_field){ echo $pt_field; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Category Field Value" name="gm_pt_value" value="<?php if($pt_value){ echo $pt_value; }?>"></td></tr>
		    </table>
		</div>
	    
	    <div style="float:left;width: 100%;clear:both">
		    <h4>Show:</h4>
		    <table width="100%">
		        <tr style="display: flex;justify-content: space-between;">
		            <td><input type="checkbox" name="gm_pt_s_pagination" <?php if($pt_s_pagination){ echo "checked"; }?> /> Pagination </td>
		            <td><input type="checkbox" name="gm_pt_s_title" <?php if($pt_s_title){ echo "checked"; }?> /> Title </td>
		            <td><input type="checkbox" name="gm_pt_s_date" <?php if($pt_s_date){ echo "checked"; }?> /> Date  </td>
		            <td><input type="checkbox" name="gm_pt_s_excerpt" <?php if($pt_s_excerpt){ echo "checked"; }?> /> Excerpt </td>
		            <td style="display: table">Display thumbnail: <select type="checkbox" name="gm_pt_s_thumbnail"/>
		            	<option <?php if($pt_s_thumbnail=="Left"){ echo "selected"; }?>>Left</option>
		            	<option <?php if($pt_s_thumbnail=="Top"){ echo "selected"; }?>>Top</option>
		            	<option <?php if($pt_s_thumbnail=="None"){ echo "selected"; }?>>None</option>
		            </td>
		            <td style="display: table">Button Text:  <input type="text" name="gm_pt_s_more" placeholder="Leave empty for display none..." value="<?php if($pt_s_more){ echo $pt_s_more; }?>"/></td>
		        </tr>
		    </table>
		    <input type="hidden" name="gm_pt-hidd" value="true" />
		</div>
    </div>

    <div id="slider-mode">
	    <div style="float:left;width: 50%">
		    <h4>Main Settings:</h4>
		    <table width="100%">
		        <tr><td><input type="text" placeholder="Post Type" name="sm_pt_type" value="<?php if($pt_type){ echo $pt_type; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Order by" name="sm_pt_orderby" value="<?php if($pt_orderby){ echo $pt_orderby; }?>"></td></tr>
				<tr><td><input type="text" placeholder="Order" name="sm_pt_order" value="<?php if($pt_order){ echo $pt_order; }?>"></td></tr>
		    </table>
		</div>
	    
	    <div style="float:left;width: 50%">
		    <table width="100%">
		    	<h4>Taxonomy Query Settings:</h4>
		    	<p>(*Optionals... submited only for tax query)</p>
				<tr><td><input type="text" placeholder="Post Type Taxonomy" name="sm_pt_tax" value="<?php if($pt_tax){ echo $pt_tax; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Category Field" name="sm_pt_field" value="<?php if($pt_field){ echo $pt_field; }?>"></td></tr>
		        <tr><td><input type="text" placeholder="Category Field Value" name="sm_pt_value" value="<?php if($pt_value){ echo $pt_value; }?>"></td></tr>
		    </table>
		</div>

		<div style="float:left;width: 100%;clear:both">
		    <h4>Show:</h4>
		    <table width="100%">
		        <tr style="display: flex;justify-content: space-between;">
		            <td><input type="checkbox" name="sm_pt_s_arrows" <?php if($pt_s_arrows){ echo "checked"; }?> /> Arrows </td>
		            <td><input type="checkbox" name="sm_pt_s_autoplay" <?php if($pt_s_autoplay){ echo "checked"; }?> /> Autoplay </td>
		            <td><input type="checkbox" name="sm_pt_s_progressbar" <?php if($pt_s_progressbar){ echo "checked"; }?> /> Progressbar  </td>
		            <td><input type="checkbox" name="sm_pt_s_loop" <?php if($pt_s_loop){ echo "checked"; }?> /> Loop </td>
		            <td style="display: table">Slider speed:  <input type="text" name="sm_pt_s_speed" placeholder="Leave empty for display none..." value="<?php if($pt_s_speed){ echo $pt_s_speed; }?>"/></td>
		            <td style="display: table">Slides number:  <input type="text" name="sm_pt_s_slides" placeholder="Leave empty for display none..." value="<?php if($pt_s_slides){ echo $pt_s_slides; }?>"/></td>
		            <td style="display: table">Gap between:  <input type="text" name="sm_pt_s_gap" placeholder="Leave empty for display none..." value="<?php if($pt_s_gap){ echo $pt_s_gap; }?>"/></td>
		        </tr>
		    </table>
		</div>
	    <div style="float:left;width: 100%;clear:both">
		    <table width="100%">
		        <tr style="display: flex;justify-content: space-between;">
		            <td><input type="checkbox" name="sm_pt_s_pagination" <?php if($pt_s_pagination){ echo "checked"; }?> /> Pagination </td>
		            <td><input type="checkbox" name="sm_pt_s_title" <?php if($pt_s_title){ echo "checked"; }?> /> Title </td>
		            <td><input type="checkbox" name="sm_pt_s_date" <?php if($pt_s_date){ echo "checked"; }?> /> Date  </td>
		            <td><input type="checkbox" name="sm_pt_s_excerpt" <?php if($pt_s_excerpt){ echo "checked"; }?> /> Excerpt </td>
		            <td style="display: table">Display thumbnail: <select type="checkbox" name="sm_pt_s_thumbnail"/>
		            	<option <?php if($pt_s_thumbnail=="Left"){ echo "selected"; }?>>Left</option>
		            	<option <?php if($pt_s_thumbnail=="Top"){ echo "selected"; }?>>Top</option>
		            	<option <?php if($pt_s_thumbnail=="None"){ echo "selected"; }?>>None</option>
		            </td>
		            <td style="display: table">Button Text:  <input type="text" name="sm_pt_s_more" placeholder="Leave empty for display none..." value="<?php if($pt_s_more){ echo $pt_s_more; }?>"/></td>
		        </tr>
		    </table>
		</div>
		<input type="hidden" name="sm_pt-hidd" value="true" />
    </div>

    
	<label style="display: block;clear:both"><?php echo get_post_meta($post->ID, 'pt_short', true); ?></label>
    <?php
}
function shortcode_add_meta_boxes() {
    add_meta_box('cpt_meta_id', 'Custom Post Type Settings', 'shortcode_details', 'shortcode', 'normal');
}
add_action('save_post', 'shortcode_save_postdata');
add_action('add_meta_boxes', 'shortcode_add_meta_boxes');
add_action( 'admin_post_my_media_update', 'importIt' );
// The functions which is going to do the job
function importIt()
{
  // Download and parse the xml
  $xml = simplexml_load_file(plugin_dir_url( __DIR__ ).'wp_toolkit/includes/shortcodes.xml');
  // Succesfully loaded?
    foreach($xml->item as $item){
    
   
      
      // Let's start with creating the post itself
      $postCreated = array(
        'post_title'  => $item->post_title,
        'post_content'  => $item->post_content,
        'post_excerpt'  => $item->post_excerpt,
        'post_status'   => 'publish',
        'post_type'   => 'shortcode', // Or "page" or some custom post type
      );
      // Get the increment id from the inserted post
      $postInsertId = wp_insert_post( $postCreated );
      add_post_meta( $postInsertId, 'pt_type', 'shortcode', true );
      // Our custom post options, for now only some meta's for the
      // Yoast SEO plugin and a "flag" to determined if a
      // post was imported or not
    
    
  }
}
add_action('admin_menu', 'create_theme_import_page');
function create_theme_import_page() {
   add_menu_page('Demo Import', 'Demo Import', 'administrator', __FILE__, 'import_page_fn');
}
function import_page_fn() {
?>
   <form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
  <input type="hidden" name="action" value="my_media_update">
  <input type="submit" value="Update Media Titles and ALT Text">
</form>
<?php
}
