<?php
add_action( 'wp_enqueue_scripts', 'enqueue_parent_styles' );
function enqueue_parent_styles() {
   wp_enqueue_style( 'parent-style', get_template_directory_uri().'/style.css' );
}

add_theme_support( 'title-tag' );

function add_theme_scripts2() {
    /*wp_enqueue_style( 'css', get_template_directory_uri() . '/css/custom.css',false,'1.1','all');*/

    wp_enqueue_script( 'script', get_stylesheet_directory_uri() . '/js/script.js', array ( 'jquery' ), 1.1, true);
}
add_action( 'wp_enqueue_scripts', 'add_theme_scripts2' );

register_sidebar( array(
'name' => 'Right Sidebar',
'id' => 'right-sidebar',
'description' => 'Appears in the services area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );

function sliderhome() {
    $args = array(
        'post_type' => 'slider',
		'posts_per_page' => -1,
        'post_status' => 'publish',
		'orderby' => 'id',
        'order'    => 'DESC',
    );
    $string = "";
    $the_query = new WP_Query($args);
    if ( $the_query->have_posts() ) {
	    $string.= '<div class="swiper-container slider-container"><div class="swiper-wrapper">';
	    while ( $the_query->have_posts() ) {
		    $the_query->the_post();
		    
		    $string .= '<div class="swiper-slide slider-slide" style="background:url('.get_the_post_thumbnail_url(get_the_ID(),'full').')">';
		    $string .= '<div class="container">';
		    $string .= '<div class="slide-inner">';
		    $string .= '<div class="slider-title"">'.get_field('title').'</div>';
		    $string .= '<div class="slider-subtitle">'.get_field('subtitle').'</div>';
		    $string .= '</div></div></div>';
	    }
	    $string .= '</div></div>';
   
    }
    wp_reset_postdata();
	return $string;
}
add_shortcode( 'sliderhome', 'sliderhome' );

function yoastVariableToTitle($post_id) {

    $yoast_title = get_post_meta($post_id, '_yoast_wpseo_title', true);
    $title = strstr($yoast_title, '%%', true);
    if (empty($title)) {
        $title = get_the_title($post_id);
    }
    $wpseo_titles = get_option('wpseo_titles');

    $sep_options = WPSEO_Option_Titles::get_instance()->get_separator_options();
    if (isset($wpseo_titles['separator']) && isset($sep_options[$wpseo_titles['separator']])) {
        $sep = $sep_options[$wpseo_titles['separator']];
    } else {
        $sep = '-'; //setting default separator if Admin didn't set it from backed
    }

    $site_title = get_bloginfo('name');

    $meta_title = $title . ' ' . $sep . ' ' . $site_title;

    return $meta_title;
}

function create_projects_tax() {
  register_taxonomy('cat-projects', 'projects',array("hierarchical" => true,"label" => "Κατηγορία Projects","singular_label" => "Κατηγορίες",'update_count_callback' => '_update_post_term_count','query_var' => true,'rewrite' => array( 'slug' => 'cat-projects', 'with_front' => false ),'public' => true,'show_ui' => true,'show_tagcloud' => true,'_builtin' => false,'show_in_nav_menus' => false));
}
add_action( 'init', 'create_projects_tax' );

function lisi () {
    return '<div class="col-md-12 lisi"><div class="main-26 blue font-700">Βρείτε λύση στο πρόβλημα σας!</div><a href="/epikoinonia">ΕΠΙΚΟΙΝΩΝΙΑ</a></div>';
}
add_shortcode('lisi', 'lisi');

function service_video() {
    if( have_rows('video') ):
        $html = '';
        $html .= '<div class="videos"><div class="main-26 font-700 blue center">Σχετικά Video</div>';
        while( have_rows('video') ) : the_row();
        
            $video_url = get_sub_field('video_url');
            $video_image = get_sub_field('video_image');
            
            $html .= '<div class="col-md-6"><a href="'.$video_url.'"><img src="'.$video_image.'"/><img class="play" src="/wp-content/uploads/2021/10/play2.png"/></a></div>';
        
        endwhile;
        $html .= '</div>';
        return $html;

    endif;
}
add_shortcode('service_video','service_video');

function create_treatments_tax() {
register_taxonomy('cat-treatments', 'treatments',array("hierarchical" => true,"label" => "Κατηγορία Treatments","singular_label" => "Κατηγορίες",'update_count_callback' => '_update_post_term_count','query_var' => true,'rewrite' => array( 'slug' => 'cat-treatments', 'with_front' => false ),'public' => true,'show_ui' => true,'show_tagcloud' => true,'_builtin' => false,'show_in_nav_menus' => false));
}

add_action( 'init', 'create_treatments_tax' );

function create_conditions_tax() {
register_taxonomy('cat-conditions', 'conditions',array("hierarchical" => true,"label" => "Κατηγορία Conditions","singular_label" => "Κατηγορίες",'update_count_callback' => '_update_post_term_count','query_var' => true,'rewrite' => array( 'slug' => 'cat-conditions', 'with_front' => false ),'public' => true,'show_ui' => true,'show_tagcloud' => true,'_builtin' => false,'show_in_nav_menus' => false));
}

add_action( 'init', 'create_conditions_tax' );