<?php

/**
 * Theme Functions
 *
 * @package Rioutheme
 * @author Riou
 * @link https:leagueofnews.eu
 */


define( 'THEME_DIR', get_template_directory() );
define( 'THEME_URI', get_template_directory_uri() );

define( 'THEME_NAME', 'rioutheme' );
define( 'THEME_VERSION', '1.0' );

define( 'LIBS_DIR', THEME_DIR. '/functions' );
define( 'LIBS_URI', THEME_URI. '/functions' );
define( 'LANG_DIR', THEME_DIR. '/languages' );

remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );
//add_filter('the_content', 'wpautop', 12);

function wpdocs_custom_excerpt_length( $length ) {
    return 20;
}
add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length', 999 );

function mytheme_post_thumbnails() {
    add_theme_support( 'post-thumbnails' );
}
add_action( 'after_setup_theme', 'mytheme_post_thumbnails' );


add_filter( 'widget_text', 'do_shortcode' );

add_theme_support( 'menus' );

function custom_wpkses_post_tags( $tags, $context ) {
	if ( 'post' === $context ) {
		$tags['iframe'] = array(
			'src'             => true,
			'height'          => true,
			'width'           => true,
			'frameborder'     => true,
			'allowfullscreen' => true,
		);
	}
	return $tags;
}
add_filter( 'wp_kses_allowed_html', 'custom_wpkses_post_tags', 10, 2 );


function register_my_menus() {
  register_nav_menus(
    array(
      'header-menu' => __( 'Header Menu' ),
      'footer-menu' => __( 'Footer Menu' )
     )
   );
 }
 add_action( 'init', 'register_my_menus' );
require_once(get_template_directory() . '/lib/tgmpa.php');


/*function filter_ptags_on_images($content)
{
    return preg_replace('/<p>(\s*)(<img .* \/>)(\s*)<\/p>/iU', '\2', $content);
    
}

add_filter('the_content', 'filter_ptags_on_images');*/

/*function filter_ptags_on_i($content)
{
    return preg_replace( '/<p>(.+)<\/p>/Uuis', '$1', $content );
    
}

add_filter('the_content', 'filter_ptags_on_i');*/


add_action('admin_menu', 'create_theme_options_page');
add_action('admin_init', 'register_and_build_fields');

function create_theme_options_page() {
   add_menu_page('Theme Options', 'Theme Options', 'administrator', __FILE__, 'options_page_fn');
}
 
function register_and_build_fields() {
   register_setting('plugin_options', 'plugin_options', 'validate_setting');
 
   add_settings_section('main_section', 'Main Settings', 'section_cb', __FILE__);
 
   add_settings_field('color_scheme', 'Color Scheme:', 'color_scheme_setting', __FILE__, 'main_section');
   add_settings_field('font', 'Font:', 'font_settingh2', __FILE__, 'main_section');
   add_settings_field('font3', 'Font:', 'font_settingh3', __FILE__, 'main_section');
   add_settings_field('logo', 'Logo:', 'logo_setting', __FILE__, 'main_section'); // LOGO
}
 
function options_page_fn() {
?>
   <div id="theme-options-wrap" class="widefat">
      <div class="icon32" id="icon-tools"></div>
 
      <h2>My Theme Options</h2>
      <p>Take control of your theme, by overriding the default settings with your own specific preferences.</p>
 
      <form method="post" action="options.php" enctype="multipart/form-data">
         <?php settings_fields('plugin_options'); ?>
         <?php do_settings_sections(__FILE__); ?>
         <p class="submit">
            <input name="Submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save Changes'); ?>" />
         </p>
   </form>
</div>
<?php
}
 
// Color Scheme
function color_scheme_setting() {
   $options = get_option('plugin_options');
   $items = array("Red", "Green", "Blue","Black","White");
 
   echo "<select name='plugin_options[color_scheme]'>";
   foreach ($items as $item) {
      $selected = ( $options['color_scheme'] === $item ) ? 'selected = "selected"' : '';
      echo "<option value='$item' $selected>$item</option>";
   }
   echo "</select>";
}

// Font
function font_settingh2() {
   $options = get_option('plugin_options');
   $items = array("Comfortaa","Russo One","Open Sans");
 
   echo "<select name='plugin_options[font]'>";
   foreach ($items as $item) {
      $selected = ( $options['font'] === $item ) ? 'selected = "selected"' : '';
      echo "<option value='$item' $selected>$item</option>";
   }
   echo "</select>";
}

function font_settingh3() {
   $options = get_option('plugin_options');
   $items = array("Comfortaa","Russo One");
 
   echo "<select name='plugin_options[font3]'>";
   foreach ($items as $item) {
      $selected = ( $options['font3'] === $item ) ? 'selected = "selected"' : '';
      echo "<option value='$item' $selected>$item</option>";
   }
   echo "</select>";
}



 
// Logo
function logo_setting() {
   echo '<input type="file" name="logo" />';
}
 
function validate_setting($plugin_options) {
   $keys = array_keys($_FILES);
   $i = 0;
 
   foreach ($_FILES as $image) {
      // if a files was upload
      if ($image['size']) {
         // if it is an image
         if (preg_match('/(jpg|jpeg|png|gif)$/', $image['type'])) {
            $override = array('test_form' => false);
            $file = wp_handle_upload($image, $override);
 
            $plugin_options[$keys[$i]] = $file['url'];
         } else {
            $options = get_option('plugin_options');
            $plugin_options[$keys[$i]] = $options[$logo];
            wp_die('No image was uploaded.');
         }
      }
 
      // else, retain the image that's already on file.
      else {
         $options = get_option('plugin_options');
         $plugin_options[$keys[$i]] = $options[$keys[$i]];
      }
      $i++;
   }
 
   return $plugin_options;
}
 
function section_cb() {}
 
// Add stylesheet
add_action('admin_head', 'admin_register_head');
 
function admin_register_head() {
   $url = get_bloginfo('template_directory') . '/functions/options_page.css';
   echo "<link rel='stylesheet' href='$url' />n";
}

register_sidebar( array(
'name' => 'Footer Sidebar 1',
'id' => 'footer-sidebar-1',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
register_sidebar( array(
'name' => 'Footer Sidebar 2',
'id' => 'footer-sidebar-2',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
register_sidebar( array(
'name' => 'Footer Sidebar 3',
'id' => 'footer-sidebar-3',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
register_sidebar( array(
'name' => 'Footer Sidebar 4',
'id' => 'footer-sidebar-4',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
register_sidebar( array(
'name' => 'Right Sidebar',
'id' => 'right-sidebar',
'description' => 'Appears in the services area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );

function wpdocs_selectively_enqueue_admin_script( $hook ) {
   
    //wp_enqueue_script( 'custom_script_one','https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.js', array(), '1.0' );
    //wp_enqueue_script( 'custom_script_two','https://netdna.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.js', array(), '1.0' );
    //wp_enqueue_script( 'custom_script_three','https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.12/summernote.js', array(), '1.0' );
    wp_enqueue_script( 'custom_script_four', get_template_directory_uri() . '/includes/assets/js/summernote.js', array(), '1.0' );
}
add_action( 'admin_enqueue_scripts', 'wpdocs_selectively_enqueue_admin_script' );

function wpdocs_selectively_enqueue_admin_style( $hook ) {
    
    // wp_register_style( 'custom_css_one', 'https://netdna.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.css', false, '1.0.0' );
     //wp_enqueue_style( 'custom_css_one' );
   // wp_register_style( 'custom_css_two', 'https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.12/summernote.css', false, '1.0.0' );
    // wp_enqueue_style( 'custom_css_two' );
}
add_action( 'admin_enqueue_styles', 'wpdocs_selectively_enqueue_admin_style' );

/**
 * Register meta box(es).
 */
function wpdocs_register_meta_boxes() {
    add_meta_box( 
    'my_comment_metabox_2',       // ID
    __('My comment metabox 2' ),  // Title 
    'prefix_comment_metabox',     // Callback
    'comment',                    // Screen
    'side'                      // Context
);
}
add_action( 'add_meta_boxes', 'wpdocs_register_meta_boxes' );
 
/**
 * Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
function wpdocs_my_display_callback( $post ) {
    // Display code/markup goes here. Don't forget to include nonces!
}
 
/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function wpdocs_save_meta_box( $post_id ) {
    // Save logic goes here. Don't forget to include nonce checks!
}
add_action( 'save_post', 'wpdocs_save_meta_box' );

function add_theme_scripts() {
    /*wp_enqueue_style( 'css', get_template_directory_uri() . '/css/custom.css',false,'1.1','all');*/

    wp_enqueue_script( 'script', get_template_directory_uri() . '/js/script.js', array ( 'jquery' ), 1.1, true);
}
add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );

function remove_plugin_styles() {
  wp_dequeue_style('wc-block-style');
    wp_dequeue_style('wc-blocks-vendors-style');
    wp_dequeue_style('wc-blocks-style'); 
    wp_dequeue_style('wp-block-library');
}
add_action( 'wp_enqueue_scripts', 'remove_plugin_styles', 100 );

function list_menu($atts, $content = null) {
	extract(shortcode_atts(array(  
		'menu'            => '', 
		'container'       => 'div', 
		'container_class' => '', 
		'container_id'    => '', 
		'menu_class'      => 'menu', 
		'menu_id'         => '',
		'echo'            => true,
		'fallback_cb'     => 'wp_page_menu',
		'before'          => '',
		'after'           => '',
		'link_before'     => '',
		'link_after'      => '',
		'depth'           => 0,
		'walker'          => '',
		'theme_location'  => ''), 
		$atts));
 
 
	return wp_nav_menu( array( 
		'menu'            => $menu, 
		'container'       => $container, 
		'container_class' => $container_class, 
		'container_id'    => $container_id, 
		'menu_class'      => $menu_class, 
		'menu_id'         => $menu_id,
		'echo'            => false,
		'fallback_cb'     => $fallback_cb,
		'before'          => $before,
		'after'           => $after,
		'link_before'     => $link_before,
		'link_after'      => $link_after,
		'depth'           => $depth,
		'walker'          => $walker,
		'theme_location'  => $theme_location));
}
//Create the shortcode
add_shortcode("listmenu", "list_menu");

function yoastVariableToTitle($post_id) {

    $yoast_title = get_post_meta($post_id, '_yoast_wpseo_title', true);
    $title = strstr($yoast_title, '%%', true);
    if (empty($title)) {
        $title = get_the_title($post_id);
    }
    $wpseo_titles = get_option('wpseo_titles');

    $sep_options = WPSEO_Option_Titles::get_instance()->get_separator_options();
    if (isset($wpseo_titles['separator']) && isset($sep_options[$wpseo_titles['separator']])) {
        $sep = $sep_options[$wpseo_titles['separator']];
    } else {
        $sep = '-'; //setting default separator if Admin didn't set it from backed
    }

    $site_title = get_bloginfo('name');

    $meta_title = $title . ' ' . $sep . ' ' . $site_title;

    return $meta_title;
}

function create_projects_tax() {
  register_taxonomy('cat-projects', 'projects',array("hierarchical" => true,"label" => "Κατηγορία Projects","singular_label" => "Κατηγορίες",'update_count_callback' => '_update_post_term_count','query_var' => true,'rewrite' => array( 'slug' => 'cat-projects', 'with_front' => false ),'public' => true,'show_ui' => true,'show_tagcloud' => true,'_builtin' => false,'show_in_nav_menus' => false));
}
add_action( 'init', 'create_projects_tax' );

function lisi () {
    return '<div class="col-md-12 lisi"><div class="main-26 blue font-700">Βρείτε λύση στο πρόβλημα σας!</div><a href="#">ΕΠΙΚΟΙΝΩΝΙΑ</a></div>';
}
add_shortcode('lisi', 'lisi');

function service_video() {
    if( have_rows('video') ):
        $html = '';
    
        while( have_rows('video') ) : the_row();
        
            $video_url = get_sub_field('video_url');
            $video_image = get_sub_field('video_image');
            
            $html .= '<div class="col-md-6"><a href="'.$video_url.'"><img src="'.$video_image.'"/><img class="play" src="/wp-content/uploads/2021/10/play2.png"/></a></div>';
        
        endwhile;
        
        return $html;

    endif;
}
add_shortcode('service_video','service_video');